/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.granite.config.flex.Adapter;
import org.granite.config.flex.DestinationRemoveListener;
import org.granite.messaging.service.security.DestinationSecurizer;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;

public class Destination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SECURIZER_PROPERTY_KEY = "securizer";
    private final String id;
    private final List<String> channelRefs;
    private final XMap properties;
    private final List<String> roles;
    private final Adapter adapter;
    private final Class<?> scannedClass;
    private DestinationSecurizer securizer;
    private DestinationRemoveListener removeListener;

    public Destination(String id, List<String> channelRefs, XMap properties, List<String> roles, Adapter adapter, Class<?> scannedClass) {
        this.id = id;
        this.channelRefs = new ArrayList<String>(channelRefs);
        this.properties = properties;
        this.roles = roles != null ? new ArrayList<String>(roles) : null;
        this.adapter = adapter;
        this.scannedClass = scannedClass;
        String securizerClassName = properties.get(SECURIZER_PROPERTY_KEY);
        if (securizerClassName != null) {
            try {
                this.securizer = TypeUtil.newInstance(securizerClassName.trim(), DestinationSecurizer.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate securizer: " + securizerClassName, e);
            }
        } else {
            this.securizer = null;
        }
    }

    public void addRemoveListener(DestinationRemoveListener listener) {
        this.removeListener = listener;
    }

    public void remove() {
        if (this.removeListener != null) {
            this.removeListener.destinationRemoved(this);
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getChannelRefs() {
        return this.channelRefs;
    }

    public XMap getProperties() {
        return this.properties;
    }

    public boolean isSecured() {
        return this.roles != null;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public Class<?> getScannedClass() {
        return this.scannedClass;
    }

    public DestinationSecurizer getSecurizer() {
        return this.securizer;
    }

    public void setSecurizer(DestinationSecurizer securizer) {
        this.securizer = securizer;
    }

    public static Destination forElement(XMap element, Adapter defaultAdapter, Map<String, Adapter> adaptersMap) {
        XMap adapter;
        String id = element.get("@id");
        ArrayList<String> channelRefs = new ArrayList<String>();
        for (XMap channel : element.getAll("channels/channel[@ref]")) {
            channelRefs.add(channel.get("@ref"));
        }
        XMap properties = new XMap(element.getOne("properties"));
        ArrayList<String> rolesList = null;
        if (element.containsKey("security/security-constraint/roles/role")) {
            rolesList = new ArrayList<String>();
            for (XMap role : element.getAll("security/security-constraint/roles/role")) {
                rolesList.add(role.get("."));
            }
        }
        Adapter adapterRef = (adapter = element.getOne("adapter[@ref]")) != null && adaptersMap != null ? adaptersMap.get(adapter.get("@ref")) : defaultAdapter;
        return new Destination(id, channelRefs, properties, rolesList, adapterRef, null);
    }
}

