/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.api.Configuration;
import org.granite.config.api.internal.ConfigurationImpl;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.logging.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractFrameworkGraniteConfig {
    private static final Logger log = Logger.getLogger(AbstractFrameworkGraniteConfig.class);
    private static final String GRANITE_CONFIG_DEFAULT = "/WEB-INF/granite/granite-config.xml";
    private static final String SERVICES_CONFIG_DEFAULT = "/WEB-INF/flex/services-config.xml";
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    protected Configuration configuration = new ConfigurationImpl();

    protected void init(ServletContext servletContext, String configPath) throws IOException, SAXException {
        InputStream is;
        String path = this.configuration.getGraniteConfig();
        if (path == null) {
            path = GRANITE_CONFIG_DEFAULT;
        }
        if ((is = servletContext.getResourceAsStream(path)) == null) {
            log.warn("Could not load custom granite-config.xml: %s (file does not exists)", path);
            path = null;
        }
        this.graniteConfig = new GraniteConfig(configPath, is, null, null);
        ServletGraniteConfig.loadConfig(servletContext, this.graniteConfig);
        path = this.configuration.getFlexServicesConfig();
        if (path == null) {
            path = SERVICES_CONFIG_DEFAULT;
        }
        if ((is = servletContext.getResourceAsStream(path)) == null) {
            log.warn("Could not load custom services-config.xml: %s (file does not exists)", path);
            path = null;
        }
        this.servicesConfig = new ServicesConfig(is, null, false);
        ServletServicesConfig.loadConfig(servletContext, this.servicesConfig);
    }

    public GraniteConfig getGraniteConfig() {
        return this.graniteConfig;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setCustomGraniteConfigPath(String path) {
        this.configuration.setGraniteConfig(path);
    }

    public void setCustomServicesConfigPath(String path) {
        this.configuration.setFlexServicesConfig(path);
    }
}

