/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.Message;
import java.util.HashMap;

public class AsyncMessage
extends AbstractMessage {
    private static final long serialVersionUID = 1L;
    public static final String SUBTOPIC_HEADER = "DSSubtopic";
    public static final String DESTINATION_CLIENT_ID_HEADER = "DSDstClientId";
    private String correlationId;

    public AsyncMessage() {
        this.setHeaders(new HashMap<String, Object>());
    }

    public AsyncMessage(Message request) {
        this(request, false);
    }

    public AsyncMessage(Message request, boolean keepClientId) {
        super(request, keepClientId);
        this.setHeaders(new HashMap<String, Object>());
        this.correlationId = request.getMessageId();
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public AsyncMessage clone() {
        AsyncMessage msg = new AsyncMessage();
        msg.setBody(this.getBody());
        msg.setClientId(this.getClientId());
        msg.setCorrelationId(this.getCorrelationId());
        msg.setDestination(this.getDestination());
        msg.setMessageId(this.getMessageId());
        msg.setHeaders(new HashMap<String, Object>(this.getHeaders()));
        msg.setTimestamp(this.getTimestamp());
        msg.setTimeToLive(this.getTimeToLive());
        return msg;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.getClass().getName()).append(" {");
        this.toString(sb, indent, null);
        sb.append('\n').append(indent).append('}');
        return sb.toString();
    }

    @Override
    protected void toString(StringBuilder sb, String indent, String bodyMessage) {
        sb.append('\n').append(indent).append("  correlationId = ").append(this.correlationId);
        super.toString(sb, indent, bodyMessage);
    }
}

