/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.LibFFITypeFactory;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFIType.ArrayType.class)
final class ArrayTypeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ArrayTypeGen() {
    }

    static {
        LibraryExport.register(LibFFIType.ArrayType.class, (LibraryExport[])new LibraryExport[]{new NativeArgumentLibraryExports()});
    }

    @GeneratedBy(value=LibFFIType.ArrayType.class)
    private static final class NativeArgumentLibraryExports
    extends LibraryExport<NativeArgumentLibrary> {
        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, LibFFIType.ArrayType.class, false);
        }

        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFIType.ArrayType);
            return new Uncached();
        }

        protected NativeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFIType.ArrayType);
            return new Cached();
        }

        @GeneratedBy(value=LibFFIType.ArrayType.class)
        private static final class Uncached
        extends NativeArgumentLibrary {
            private final TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = this.lookupLanguageReference(NFILanguageImpl.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFIType.ArrayType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ArrayType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFIType.ArrayType && Uncached.accepts_(receiver);
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                arg0Value.serialize(arg1Value, arg2Value, LibFFITypeFactory.ArrayTypeFactory.SerializeHelperNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                return arg0Value.deserializeRet(arg1Value, (NFILanguageImpl)this.nFILanguageImplReference_.get());
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                return arg0Value.accepts(arg0Value.elementType);
            }
        }

        @GeneratedBy(value=LibFFIType.ArrayType.class)
        private static final class Cached
        extends NativeArgumentLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @CompilerDirectives.CompilationFinal
            private NativeSimpleType acceptsNode__cachedType_;
            @Node.Child
            private LibFFIType.ArrayType.SerializeHelperNode serializeNode__serializeHelper_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFIType.ArrayType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ArrayType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFIType.ArrayType && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return arg0Value.accepts(this.acceptsNode__cachedType_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean acceptsNode_AndSpecialize(LibFFIType.ArrayType arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.acceptsNode__cachedType_ = arg0Value.elementType;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.accepts(this.acceptsNode__cachedType_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.serializeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void serializeNode_AndSpecialize(LibFFIType.ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.serializeNode__serializeHelper_ = (LibFFIType.ArrayType.SerializeHelperNode)super.insert((Node)LibFFITypeFactory.ArrayTypeFactory.SerializeHelperNodeGen.create());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFIType.ArrayType arg0Value = (LibFFIType.ArrayType)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    return arg0Value.deserializeRet(arg1Value, (NFILanguageImpl)this.nFILanguageImplReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.deserializeRetNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object deserializeRetNode_AndSpecialize(LibFFIType.ArrayType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference nFILanguageImplReference__ = this.nFILanguageImplReference_;
                    if (nFILanguageImplReference__ == null) {
                        this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.deserializeRet(arg1Value, (NFILanguageImpl)nFILanguageImplReference__.get());
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

