/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.spi.NFIBackendTools;
import org.graalvm.collections.EconomicMap;

final class NFIContext {
    private static final NFIBackendTools TOOLS = new NFIBackendTools(){

        @Override
        public Object createBindableSymbol(Object symbol) {
            return NFISymbol.createBindable(symbol);
        }

        @Override
        public Object createBoundSymbol(Object symbol, Object signature) {
            return NFISymbol.createBound(symbol, signature);
        }
    };
    TruffleLanguage.Env env;
    final EconomicMap<String, NFIBackend> backendCache = EconomicMap.create();

    NFIContext(TruffleLanguage.Env env) {
        this.env = env;
    }

    void patch(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
        this.backendCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NFIBackend getBackend(String id) {
        NFIBackend ret = (NFIBackend)this.backendCache.get((Object)id);
        if (ret != null) {
            return ret;
        }
        EconomicMap<String, NFIBackend> economicMap = this.backendCache;
        synchronized (economicMap) {
            ret = (NFIBackend)this.backendCache.get((Object)id);
            if (ret != null) {
                return ret;
            }
            for (LanguageInfo language : this.env.getInternalLanguages().values()) {
                NFIBackendFactory backendFactory;
                block9: {
                    if ("nfi".equals(language.getId()) || (backendFactory = (NFIBackendFactory)this.env.lookup(language, NFIBackendFactory.class)) == null || !backendFactory.getBackendId().equals(id)) continue;
                    Source source = Source.newBuilder((String)language.getId(), (CharSequence)"", (String)"").internal(true).build();
                    try {
                        this.env.parseInternal(source, new String[0]);
                    }
                    catch (Exception ex) {
                        TruffleException te;
                        boolean rethrow = true;
                        if (ex instanceof TruffleException && ((te = (TruffleException)ex).isIncompleteSource() || te.isSyntaxError())) {
                            rethrow = false;
                        }
                        if (!rethrow) break block9;
                        throw ex;
                    }
                }
                NFIBackend backend = backendFactory.createBackend(TOOLS);
                this.backendCache.put((Object)backendFactory.getBackendId(), (Object)backend);
                return backend;
            }
        }
        return null;
    }
}

