/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class IntValueProfile
extends Profile {
    IntValueProfile() {
    }

    public abstract int profile(int var1);

    public static IntValueProfile createIdentityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    public static IntValueProfile getUncached() {
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends IntValueProfile {
        static final IntValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public int profile(int value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(IntValueProfile.class);
        }
    }

    static final class Enabled
    extends IntValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private int cachedValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public int profile(int value) {
            byte localState = this.state;
            if (localState != 2) {
                int v;
                if (localState == 1 && (v = this.cachedValue) == value) {
                    return v;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }

        boolean isGeneric() {
            return this.state == 2;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        int getCachedValue() {
            return this.cachedValue;
        }

        @Override
        public void disable() {
            this.state = (byte)2;
        }

        @Override
        public void reset() {
            this.state = 0;
        }

        public String toString() {
            return this.toString(IntValueProfile.class, this.isUninitialized(), this.isGeneric(), String.format("value == (int)%s", this.cachedValue));
        }

        static IntValueProfile create() {
            return new Enabled();
        }
    }
}

