/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotReferences;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.polyglot.Source;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    private final PolyglotSourceCache sourceCache;
    private final Map<Class<?>, PolyglotValueDispatch> valueCache;
    private final Map<Class<?>, CallTarget> callTargetCache;
    final Map<Object, Object> hostToGuestCodeCache = new ConcurrentHashMap<Object, Object>();
    private volatile OptionValuesImpl firstOptionValues;
    private volatile boolean multiContextInitialized;
    private final Assumption singleContext = Truffle.getRuntime().createAssumption("Single context per language instance.");
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> directLanguageSupplier;
    private final TruffleLanguage.ContextReference<Object> directContextSupplier;
    List<PolyglotLocals.LanguageContextLocal<?>> contextLocals;
    List<PolyglotLocals.LanguageContextThreadLocal<?>> contextThreadLocals;
    PolyglotLocals.LocalLocation[] contextLocalLocations;
    PolyglotLocals.LocalLocation[] contextThreadLocalLocations;
    int claimedCount;

    PolyglotLanguageInstance(PolyglotLanguage language) {
        Assumption useInnerContext;
        this.language = language;
        this.sourceCache = new PolyglotSourceCache();
        this.valueCache = new ConcurrentHashMap();
        this.callTargetCache = new ConcurrentHashMap();
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, this);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        boolean mayBeUsedInInnerContext = language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE;
        boolean currentExclusive = language.getEffectiveContextPolicy(language) == TruffleLanguage.ContextPolicy.EXCLUSIVE;
        Assumption useDirectSingleContext = currentExclusive ? null : this.singleContext;
        Assumption assumption = useInnerContext = mayBeUsedInInnerContext ? language.engine.noInnerContexts : null;
        this.directContextSupplier = language.engine.conservativeContextReferences ? language.getConservativeContextReference() : (useDirectSingleContext == null && useInnerContext == null ? PolyglotReferences.createAlwaysSingleContext(language, currentExclusive) : PolyglotReferences.createAssumeSingleContext(language, useInnerContext, useDirectSingleContext, language.getContextReference(), currentExclusive));
        this.directLanguageSupplier = PolyglotReferences.createAlwaysSingleLanguage(language, this);
        PolyglotValueDispatch.createDefaultValues(this.getImpl(), this, this.valueCache);
    }

    CallTarget lookupCallTarget(Class<? extends RootNode> rootNodeClass) {
        return this.callTargetCache.get(rootNodeClass);
    }

    CallTarget installCallTarget(RootNode rootNode) {
        return this.callTargetCache.computeIfAbsent(rootNode.getClass(), r -> Truffle.getRuntime().createCallTarget(rootNode));
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    boolean areOptionsCompatible(OptionValuesImpl newOptionValues) {
        OptionValuesImpl firstOptions = this.firstOptionValues;
        if (this.firstOptionValues == null) {
            return true;
        }
        return EngineAccessor.LANGUAGE.areOptionsCompatible(this.spi, firstOptions, newOptionValues);
    }

    void claim(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine.lock));
        if (this.firstOptionValues == null) {
            this.firstOptionValues = optionValues;
        }
        ++this.claimedCount;
    }

    void patchFirstOptions(OptionValuesImpl optionValues) {
        this.firstOptionValues = optionValues;
    }

    void ensureMultiContextInitialized() {
        assert (Thread.holdsLock(this.language.engine.lock));
        if (!this.language.engine.singleContext.isValid() && this.language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE && !this.multiContextInitialized) {
            this.multiContextInitialized = true;
            this.language.engine.initializeMultiContext(null);
            this.singleContext.invalidate();
            EngineAccessor.LANGUAGE.initializeMultiContext(this.spi);
        }
    }

    PolyglotSourceCache getSourceCache() {
        return this.sourceCache;
    }

    TruffleLanguage.ContextReference<Object> getDirectContextSupplier() {
        return this.directContextSupplier;
    }

    TruffleLanguage.ContextReference<Object> lookupContextSupplier(PolyglotLanguage sourceLanguage) {
        PolyglotReferences.AbstractContextReference ref;
        assert (this.language != sourceLanguage);
        switch (this.language.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                ref = PolyglotReferences.createAssumeSingleContext(this.language, this.language.engine.noInnerContexts, null, this.language.getContextReference(), true);
                break;
            }
            case REUSE: 
            case SHARED: {
                ref = this.language.getContextReference();
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        return ref;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getDirectLanguageReference() {
        return this.directLanguageSupplier;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> lookupLanguageSupplier(PolyglotLanguage sourceLanguage) {
        assert (this.language != sourceLanguage);
        switch (this.language.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                return PolyglotReferences.createAssumeSingleLanguage(this.language, this, this.language.singleInstance, this.language.getLanguageReference());
            }
            case REUSE: 
            case SHARED: {
                return this.language.getLanguageReference();
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    void listCachedSources(Collection<Source> sources) {
        this.sourceCache.listCachedSources(this, sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotValueDispatch lookupValueCache(PolyglotContextImpl context, Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.get(guestValue.getClass());
        if (cache == null) {
            Object prev = this.language.engine.enterIfNeeded(context, true);
            try {
                cache = this.lookupValueCacheImpl(guestValue);
            }
            finally {
                this.language.engine.leaveIfNeeded(prev, context);
            }
        }
        return cache;
    }

    private synchronized PolyglotValueDispatch lookupValueCacheImpl(final Object guestValue) {
        PolyglotValueDispatch cache = this.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValueDispatch>(){

            @Override
            public PolyglotValueDispatch apply(Class<?> t) {
                return PolyglotValueDispatch.createInteropValue(PolyglotLanguageInstance.this, (TruffleObject)guestValue, guestValue.getClass());
            }
        });
        return cache;
    }
}

