// CheckStyle: start generated
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Debug Info: <pre>
 *   Specialization {@link AbsNode#absInt}
 *     Activation probability: 0.38500
 *     With/without class size: 11/1 bytes
 *   Specialization {@link AbsNode#absIntSpecial}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link AbsNode#absDouble}
 *     Activation probability: 0.20500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link AbsNode#absGeneric}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(AbsNode.class)
@SuppressWarnings("javadoc")
public final class AbsNodeGen extends AbsNode implements Introspection.Provider {

    private static final StateField STATE_0_AbsNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link AbsNode#absInt}
     *   Parameter: {@link InlinedConditionProfile} negative
     *   Inline method: {@link InlinedConditionProfile#inline}</pre>
     */
    private static final InlinedConditionProfile INLINED_ABS_INT_NEGATIVE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_AbsNode_UPDATER.subUpdater(8, 2)));

    @Child private JavaScriptNode arguments0_;
    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link AbsNode#absInt}
     *   1: SpecializationExcluded {@link AbsNode#absInt}
     *   2: SpecializationActive {@link AbsNode#absIntSpecial}
     *   3: SpecializationActive {@link AbsNode#absDouble}
     *   4: SpecializationActive {@link AbsNode#absGeneric}
     *   5-7: ImplicitCast[type=double, index=0]
     *   8-9: InlinedCache
     *        Specialization: {@link AbsNode#absInt}
     *        Parameter: {@link InlinedConditionProfile} negative
     *        Inline method: {@link InlinedConditionProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;

    private AbsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[] {this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11000) == 0 /* only-active SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
            return execute_int0(state_0, frameValue);
        } else if ((state_0 & 0b10101) == 0 /* only-active SpecializationActive[AbsNode.absDouble(double)] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
            return execute_double1(state_0, frameValue);
        } else {
            return execute_generic2(state_0, frameValue);
        }
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if ((state_0 & 0b101) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] || SpecializationActive[AbsNode.absIntSpecial(int)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */) {
                try {
                    return absInt(arguments0Value_, INLINED_ABS_INT_NEGATIVE_);
                } catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(arguments0Value_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] */) {
                return AbsNode.absIntSpecial(arguments0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[AbsNode.absDouble(double)] */;
        return AbsNode.absDouble(arguments0Value_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b11101) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] || SpecializationActive[AbsNode.absIntSpecial(int)] || SpecializationActive[AbsNode.absDouble(double)] || SpecializationActive[AbsNode.absGeneric(Object)] */) {
            if ((state_0 & 0b101) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] || SpecializationActive[AbsNode.absIntSpecial(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */) {
                    try {
                        return absInt(arguments0Value__, INLINED_ABS_INT_NEGATIVE_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        return executeAndSpecialize(arguments0Value__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] */) {
                    return AbsNode.absIntSpecial(arguments0Value__);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[AbsNode.absDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return AbsNode.absDouble(arguments0Value__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[AbsNode.absGeneric(Object)] */) {
                return absGeneric(arguments0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11000) == 0 /* only-active SpecializationActive[AbsNode.absIntSpecial(int)] */ && ((state_0 & 0b11100) != 0  /* is-not SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
            return executeDouble_int3(state_0, frameValue);
        } else if ((state_0 & 0b10100) == 0 /* only-active SpecializationActive[AbsNode.absDouble(double)] */ && ((state_0 & 0b11100) != 0  /* is-not SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
            return executeDouble_double4(state_0, frameValue);
        } else {
            return executeDouble_generic5(state_0, frameValue);
        }
    }

    private double executeDouble_int3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] */;
        return AbsNode.absIntSpecial(arguments0Value_);
    }

    private double executeDouble_double4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        double arguments0Value_;
        try {
            if ((state_0 & 0b11000000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0b10100000) == 0 /* only-active ImplicitCast[type=double, index=0] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value__);
            }
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(executeAndSpecialize(ex.getResult()));
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[AbsNode.absDouble(double)] */;
        return AbsNode.absDouble(arguments0Value_);
    }

    private double executeDouble_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 0b11100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] || SpecializationActive[AbsNode.absDouble(double)] || SpecializationActive[AbsNode.absGeneric(Object)] */) {
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] */ && arguments0Value_ instanceof Integer) {
                int arguments0Value__ = (int) arguments0Value_;
                return AbsNode.absIntSpecial(arguments0Value__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[AbsNode.absDouble(double)] */ && JSTypesGen.isImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=double, index=0] */, arguments0Value_);
                return AbsNode.absDouble(arguments0Value__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[AbsNode.absGeneric(Object)] */) {
                return absGeneric(arguments0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(executeAndSpecialize(arguments0Value_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */) {
            try {
                return absInt(arguments0Value_, INLINED_ABS_INT_NEGATIVE_);
            } catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */;
                state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                executeInt(frameValue);
                return;
            } else if ((state_0 & 0b1) == 0 /* only-active SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */ && ((state_0 & 0b11101) != 0  /* is-not SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] && SpecializationActive[AbsNode.absIntSpecial(int)] && SpecializationActive[AbsNode.absDouble(double)] && SpecializationActive[AbsNode.absGeneric(Object)] */)) {
                executeDouble(frameValue);
                return;
            }
            execute(frameValue);
            return;
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        if (arguments0Value instanceof Integer) {
            int arguments0Value_ = (int) arguments0Value;
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */;
                this.state_0_ = state_0;
                try {
                    return absInt(arguments0Value_, INLINED_ABS_INT_NEGATIVE_);
                } catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(arguments0Value_);
                }
            }
            state_0 = state_0 | 0b100 /* add SpecializationActive[AbsNode.absIntSpecial(int)] */;
            this.state_0_ = state_0;
            return AbsNode.absIntSpecial(arguments0Value_);
        }
        {
            int doubleCast0;
            if ((doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value)) != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state_0 = (state_0 | (doubleCast0 << 5) /* set-int ImplicitCast[type=double, index=0] */);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[AbsNode.absDouble(double)] */;
                this.state_0_ = state_0;
                return AbsNode.absDouble(arguments0Value_);
            }
        }
        state_0 = state_0 | 0b10000 /* add SpecializationActive[AbsNode.absGeneric(Object)] */;
        this.state_0_ = state_0;
        return absGeneric(arguments0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11101) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11101) & ((state_0 & 0b11101) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        Object[] s;
        data[0] = 0;
        int state_0 = this.state_0_;
        s = new Object[3];
        s[0] = "absInt";
        if ((state_0 & 0b1) != 0 /* is SpecializationActive[AbsNode.absInt(int, InlinedConditionProfile)] */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.<Object>asList(INLINED_ABS_INT_NEGATIVE_));
            s[2] = cached;
        }
        if (s[1] == null) {
            if (((state_0 & 0b10)) == 0 /* is-not SpecializationExcluded  */) {
                s[1] = (byte)0b10 /* excluded */;
            } else {
                s[1] = (byte)0b00 /* inactive */;
            }
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "absIntSpecial";
        if ((state_0 & 0b100) != 0 /* is SpecializationActive[AbsNode.absIntSpecial(int)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "absDouble";
        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[AbsNode.absDouble(double)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "absGeneric";
        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[AbsNode.absGeneric(Object)] */) {
            s[1] = (byte)0b01 /* active */;
        }
        if (s[1] == null) {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        return Provider.create(data);
    }

    @NeverDefault
    public static AbsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new AbsNodeGen(context, builtin, arguments);
    }

}
