/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;

public class SSLEngineConfigurator {
    private final Object sync = new Object();
    protected volatile SSLContextConfigurator sslContextConfiguration;
    protected volatile SSLContext sslContext;
    protected String[] enabledCipherSuites = null;
    protected String[] enabledProtocols = null;
    protected boolean clientMode;
    protected boolean needClientAuth;
    protected boolean wantClientAuth;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;

    public SSLEngineConfigurator(SSLContext sslContext) {
        this(sslContext, true, false, false);
    }

    public SSLEngineConfigurator(SSLContext sslContext, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext can not be null");
        }
        this.sslContextConfiguration = null;
        this.sslContext = sslContext;
        this.clientMode = clientMode;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration) {
        this(sslContextConfiguration, true, false, false);
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContextConfiguration == null) {
            throw new IllegalArgumentException("SSLContextConfigurator can not be null");
        }
        this.sslContextConfiguration = sslContextConfiguration;
        this.clientMode = clientMode;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngineConfigurator(SSLEngineConfigurator pattern) {
        this.sslContextConfiguration = pattern.sslContextConfiguration;
        this.sslContext = pattern.sslContext;
        this.clientMode = pattern.clientMode;
        this.needClientAuth = pattern.needClientAuth;
        this.wantClientAuth = pattern.wantClientAuth;
        this.enabledCipherSuites = pattern.enabledCipherSuites;
        this.enabledProtocols = pattern.enabledProtocols;
        this.isCipherConfigured = pattern.isCipherConfigured;
        this.isProtocolConfigured = pattern.isProtocolConfigured;
    }

    protected SSLEngineConfigurator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngine createSSLEngine() {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext();
                }
            }
        }
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.configure(sslEngine);
        return sslEngine;
    }

    public SSLEngine configure(SSLEngine sslEngine) {
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLEngineConfigurator.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLEngineConfigurator.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        if (this.wantClientAuth) {
            sslEngine.setWantClientAuth(this.wantClientAuth);
        }
        if (this.needClientAuth) {
            sslEngine.setNeedClientAuth(this.needClientAuth);
        }
        return sslEngine;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public SSLEngineConfigurator setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLEngineConfigurator setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public SSLEngineConfigurator setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public SSLEngineConfigurator setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
        return this;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public SSLEngineConfigurator setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public boolean isCipherConfigured() {
        return this.isCipherConfigured;
    }

    public SSLEngineConfigurator setCipherConfigured(boolean isCipherConfigured) {
        this.isCipherConfigured = isCipherConfigured;
        return this;
    }

    public boolean isProtocolConfigured() {
        return this.isProtocolConfigured;
    }

    public SSLEngineConfigurator setProtocolConfigured(boolean isProtocolConfigured) {
        this.isProtocolConfigured = isProtocolConfigured;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext();
                }
            }
        }
        return this.sslContext;
    }

    private static String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLEngineConfigurator");
        sb.append("{clientMode=").append(this.clientMode);
        sb.append(", enabledCipherSuites=").append(this.enabledCipherSuites == null ? "null" : Arrays.asList(this.enabledCipherSuites).toString());
        sb.append(", enabledProtocols=").append(this.enabledProtocols == null ? "null" : Arrays.asList(this.enabledProtocols).toString());
        sb.append(", needClientAuth=").append(this.needClientAuth);
        sb.append(", wantClientAuth=").append(this.wantClientAuth);
        sb.append(", isProtocolConfigured=").append(this.isProtocolConfigured);
        sb.append(", isCipherConfigured=").append(this.isCipherConfigured);
        sb.append('}');
        return sb.toString();
    }

    public SSLEngineConfigurator copy() {
        return new SSLEngineConfigurator(this);
    }
}

