/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.repository.DiagramEdge;
import org.activiti.engine.repository.DiagramElement;
import org.activiti.engine.repository.DiagramNode;

public class DiagramLayout
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, DiagramElement> elements;

    public DiagramLayout(Map<String, DiagramElement> elements) {
        this.setElements(elements);
    }

    public DiagramNode getNode(String id) {
        DiagramElement element = this.getElements().get(id);
        if (element instanceof DiagramNode) {
            return (DiagramNode)element;
        }
        return null;
    }

    public DiagramEdge getEdge(String id) {
        DiagramElement element = this.getElements().get(id);
        if (element instanceof DiagramEdge) {
            return (DiagramEdge)element;
        }
        return null;
    }

    public Map<String, DiagramElement> getElements() {
        return this.elements;
    }

    public void setElements(Map<String, DiagramElement> elements) {
        this.elements = elements;
    }

    public List<DiagramNode> getNodes() {
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        for (Map.Entry<String, DiagramElement> entry : this.getElements().entrySet()) {
            DiagramElement element = entry.getValue();
            if (!(element instanceof DiagramNode)) continue;
            nodes.add((DiagramNode)element);
        }
        return nodes;
    }
}

