/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;

public final class ByteArrayRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private ByteArrayEntity entity;
    protected boolean deleted;

    public ByteArrayRef() {
    }

    public ByteArrayRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    private void setBytes(byte[] bytes) {
        if (this.id == null) {
            if (bytes != null) {
                this.entity = ByteArrayEntity.createAndInsert(this.name, bytes);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
        }
    }

    public ByteArrayEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                Context.getCommandContext().getByteArrayEntityManager().deleteByteArray(this.entity);
            } else {
                Context.getCommandContext().getByteArrayEntityManager().deleteByteArrayById(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = Context.getCommandContext().getByteArrayEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return "ByteArrayRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

