/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.conf;

import org.flowable.idm.api.IdmIdentityService;
import org.flowable.ui.common.properties.FlowableRestAppProperties;
import org.flowable.ui.common.security.ActuatorRequestMatcher;
import org.flowable.ui.common.security.ClearFlowableCookieLogoutHandler;
import org.flowable.ui.idm.properties.FlowableIdmAppProperties;
import org.flowable.ui.idm.security.AjaxAuthenticationFailureHandler;
import org.flowable.ui.idm.security.AjaxAuthenticationSuccessHandler;
import org.flowable.ui.idm.security.AjaxLogoutSuccessHandler;
import org.flowable.ui.idm.security.CustomDaoAuthenticationProvider;
import org.flowable.ui.idm.security.CustomLdapAuthenticationProvider;
import org.flowable.ui.idm.security.CustomPersistentRememberMeServices;
import org.flowable.ui.idm.security.Http401UnauthorizedEntryPoint;
import org.flowable.ui.idm.web.CustomFormLoginConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
@EnableGlobalMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
public class SecurityConfiguration {
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired
    protected FlowableIdmAppProperties idmAppProperties;

    @Bean
    public org.flowable.ui.idm.security.UserDetailsService userDetailsService() {
        org.flowable.ui.idm.security.UserDetailsService userDetailsService = new org.flowable.ui.idm.security.UserDetailsService();
        userDetailsService.setUserValidityPeriod(this.idmAppProperties.getSecurity().getUserValidityPeriod());
        return userDetailsService;
    }

    @Bean(name={"dbAuthenticationProvider"})
    @ConditionalOnMissingBean(value={AuthenticationProvider.class})
    @ConditionalOnProperty(prefix="flowable.idm.ldap", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public AuthenticationProvider dbAuthenticationProvider(PasswordEncoder passwordEncoder, UserDetailsService userDetailsService) {
        CustomDaoAuthenticationProvider daoAuthenticationProvider = new CustomDaoAuthenticationProvider();
        daoAuthenticationProvider.setUserDetailsService(userDetailsService);
        daoAuthenticationProvider.setPasswordEncoder(passwordEncoder);
        return daoAuthenticationProvider;
    }

    @Bean(name={"ldapAuthenticationProvider"})
    @ConditionalOnProperty(prefix="flowable.idm.ldap", name={"enabled"}, havingValue="true")
    public AuthenticationProvider ldapAuthenticationProvider(UserDetailsService userDetailsService) {
        CustomLdapAuthenticationProvider ldapAuthenticationProvider = new CustomLdapAuthenticationProvider(userDetailsService, this.identityService);
        return ldapAuthenticationProvider;
    }

    @Bean
    public CustomPersistentRememberMeServices rememberMeServices(UserDetailsService userDetailsService) {
        return new CustomPersistentRememberMeServices(this.idmAppProperties, userDetailsService);
    }

    @ConditionalOnClass(value={EndpointRequest.class})
    @Configuration
    @Order(value=5)
    public static class ActuatorWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new ActuatorRequestMatcher()).authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{InfoEndpoint.class, HealthEndpoint.class})})).authenticated().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasAnyAuthority(new String[]{"access-admin"}).and()).httpBasic();
        }
    }

    @Configuration
    @Order(value=1)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final FlowableRestAppProperties restAppProperties;
        protected final FlowableIdmAppProperties idmAppProperties;

        public ApiWebSecurityConfigurationAdapter(FlowableRestAppProperties restAppProperties, FlowableIdmAppProperties idmAppProperties) {
            this.restAppProperties = restAppProperties;
            this.idmAppProperties = idmAppProperties;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            if (this.idmAppProperties.isRestEnabled()) {
                if (this.restAppProperties.isVerifyRestApiPrivilege()) {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).hasAuthority("access-rest-api").and()).httpBasic();
                } else {
                    ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().and()).httpBasic();
                }
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/**").authorizeRequests().antMatchers(new String[]{"/api/**"})).denyAll();
            }
        }
    }

    @Configuration
    @Order(value=10)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private FlowableIdmAppProperties idmAppProperties;
        @Autowired
        private AjaxAuthenticationSuccessHandler ajaxAuthenticationSuccessHandler;
        @Autowired
        private AjaxAuthenticationFailureHandler ajaxAuthenticationFailureHandler;
        @Autowired
        private AjaxLogoutSuccessHandler ajaxLogoutSuccessHandler;
        @Autowired
        private Http401UnauthorizedEntryPoint authenticationEntryPoint;
        @Autowired
        private RememberMeServices rememberMeServices;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).rememberMe().rememberMeServices(this.rememberMeServices).key(this.idmAppProperties.getSecurity().getRememberMeKey()).and()).logout().logoutUrl("/app/logout").logoutSuccessHandler((LogoutSuccessHandler)this.ajaxLogoutSuccessHandler).addLogoutHandler((LogoutHandler)new ClearFlowableCookieLogoutHandler()).permitAll().and()).csrf().disable()).headers().frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter()).and()).authorizeRequests().antMatchers(new String[]{"/*"})).permitAll().antMatchers(new String[]{"/app/rest/authenticate"})).permitAll().antMatchers(new String[]{"/app/**"})).hasAuthority("access-idm");
            CustomFormLoginConfig loginConfig = new CustomFormLoginConfig();
            ((CustomFormLoginConfig)((CustomFormLoginConfig)((CustomFormLoginConfig)loginConfig.loginProcessingUrl("/app/authentication")).successHandler((AuthenticationSuccessHandler)this.ajaxAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.ajaxAuthenticationFailureHandler)).usernameParameter("j_username").passwordParameter("j_password").permitAll();
            http.apply(loginConfig);
        }
    }
}

