/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client.modelinfo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.admin.rest.client.modelinfo.InfoMapper;

public abstract class AbstractInfoMapper
implements InfoMapper {
    protected DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ArrayNode propertiesNode;

    @Override
    public ArrayNode map(Object element) {
        this.propertiesNode = this.objectMapper.createArrayNode();
        this.mapProperties(element);
        return this.propertiesNode;
    }

    protected abstract void mapProperties(Object var1);

    protected void createPropertyNode(String name, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ObjectNode propertyNode = this.objectMapper.createObjectNode();
            propertyNode.put("name", name);
            propertyNode.put("value", value);
            this.propertiesNode.add((JsonNode)propertyNode);
        }
    }

    protected void createPropertyNode(String name, Date value) {
        if (value != null) {
            this.createPropertyNode(name, this.dateFormat.format(value));
        }
    }

    protected void createPropertyNode(String name, Boolean value) {
        if (value != null) {
            this.createPropertyNode(name, value.toString());
        }
    }

    protected void createPropertyNode(String name, List<String> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            StringBuilder commaSeperatedString = new StringBuilder();
            for (String value : values) {
                if (commaSeperatedString.length() > 0) {
                    commaSeperatedString.append(", ");
                }
                commaSeperatedString.append(value);
            }
            this.createPropertyNode(name, commaSeperatedString.toString());
        }
    }
}

