/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Pool;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.TextAnnotation;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.rest.client.modelinfo.InfoMapper;
import org.flowable.ui.admin.rest.client.modelinfo.bpmn.ServiceTaskInfoMapper;
import org.flowable.ui.admin.rest.client.modelinfo.bpmn.UserTaskInfoMapper;
import org.flowable.ui.admin.service.engine.ProcessDefinitionService;
import org.flowable.ui.admin.service.engine.ProcessInstanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DisplayJsonClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisplayJsonClientResource.class);
    @Autowired
    protected ProcessDefinitionService clientService;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<String> eventElementTypes = new ArrayList<String>();
    protected Map<String, InfoMapper> propertyMappers = new HashMap<String, InfoMapper>();

    public DisplayJsonClientResource() {
        this.eventElementTypes.add("StartEvent");
        this.eventElementTypes.add("EndEvent");
        this.eventElementTypes.add("BoundaryEvent");
        this.eventElementTypes.add("IntermediateCatchEvent");
        this.eventElementTypes.add("ThrowEvent");
        this.propertyMappers.put("ServiceTask", new ServiceTaskInfoMapper());
        this.propertyMappers.put("UserTask", new UserTaskInfoMapper());
    }

    @GetMapping(value={"/rest/admin/process-definitions/{processDefinitionId}/model-json"}, produces={"application/json"})
    public JsonNode getProcessDefinitionModelJSON(@PathVariable String processDefinitionId) {
        ServerConfig config = this.retrieveServerConfig(EndpointType.PROCESS);
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        BpmnModel pojoModel = this.clientService.getProcessDefinitionModel(config, processDefinitionId);
        if (!pojoModel.getLocationMap().isEmpty()) {
            try {
                GraphicInfo diagramInfo = new GraphicInfo();
                this.processProcessElements(config, pojoModel, displayNode, diagramInfo, null, null);
                displayNode.put("diagramBeginX", diagramInfo.getX());
                displayNode.put("diagramBeginY", diagramInfo.getY());
                displayNode.put("diagramWidth", diagramInfo.getWidth());
                displayNode.put("diagramHeight", diagramInfo.getHeight());
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
            }
        }
        return displayNode;
    }

    @GetMapping(value={"/rest/admin/process-instances/{processInstanceId}/model-json"}, produces={"application/json"})
    public JsonNode getProcessInstanceModelJSON(@PathVariable String processInstanceId, @RequestParam(required=true) String processDefinitionId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        ServerConfig config = this.retrieveServerConfig(EndpointType.PROCESS);
        BpmnModel pojoModel = this.clientService.getProcessDefinitionModel(config, processDefinitionId);
        if (!pojoModel.getLocationMap().isEmpty()) {
            List completedActivityInstances = this.processInstanceService.getCompletedActivityInstancesAndProcessDefinitionId(config, processInstanceId);
            List currentActivityinstances = this.processInstanceService.getCurrentActivityInstances(config, processInstanceId);
            List<String> completedFlows = this.gatherCompletedFlows(completedActivityInstances, currentActivityinstances, pojoModel);
            try {
                GraphicInfo diagramInfo = new GraphicInfo();
                HashSet<String> completedElements = new HashSet<String>(completedActivityInstances);
                completedElements.addAll(completedFlows);
                HashSet<String> currentElements = new HashSet<String>(currentActivityinstances);
                this.processProcessElements(config, pojoModel, displayNode, diagramInfo, completedElements, currentElements);
                displayNode.put("diagramBeginX", diagramInfo.getX());
                displayNode.put("diagramBeginY", diagramInfo.getY());
                displayNode.put("diagramWidth", diagramInfo.getWidth());
                displayNode.put("diagramHeight", diagramInfo.getHeight());
                if (completedActivityInstances != null) {
                    ArrayNode completedActivities = displayNode.putArray("completedActivities");
                    for (String completed : completedActivityInstances) {
                        completedActivities.add(completed);
                    }
                }
                if (currentActivityinstances != null) {
                    ArrayNode currentActivities = displayNode.putArray("currentActivities");
                    for (String current : currentActivityinstances) {
                        currentActivities.add(current);
                    }
                }
                if (completedFlows != null) {
                    ArrayNode completedSequenceFlows = displayNode.putArray("completedSequenceFlows");
                    for (String current : completedFlows) {
                        completedSequenceFlows.add(current);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
            }
        }
        return displayNode;
    }

    @GetMapping(value={"/rest/admin/process-instances/{processInstanceId}/history-model-json"}, produces={"application/json"})
    public JsonNode getHistoryProcessInstanceModelJSON(@PathVariable String processInstanceId, @RequestParam(required=true) String processDefinitionId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        ServerConfig config = this.retrieveServerConfig(EndpointType.PROCESS);
        BpmnModel pojoModel = this.clientService.getProcessDefinitionModel(config, processDefinitionId);
        if (!pojoModel.getLocationMap().isEmpty()) {
            List completedActivityInstances = this.processInstanceService.getCompletedActivityInstancesAndProcessDefinitionId(config, processInstanceId);
            List<String> completedFlows = this.gatherCompletedFlows(completedActivityInstances, null, pojoModel);
            try {
                GraphicInfo diagramInfo = new GraphicInfo();
                HashSet<String> completedElements = new HashSet<String>(completedActivityInstances);
                completedElements.addAll(completedFlows);
                this.processProcessElements(config, pojoModel, displayNode, diagramInfo, completedElements, null);
                displayNode.put("diagramBeginX", diagramInfo.getX());
                displayNode.put("diagramBeginY", diagramInfo.getY());
                displayNode.put("diagramWidth", diagramInfo.getWidth());
                displayNode.put("diagramHeight", diagramInfo.getHeight());
                if (completedActivityInstances != null) {
                    ArrayNode completedActivities = displayNode.putArray("completedActivities");
                    for (String completed : completedActivityInstances) {
                        completedActivities.add(completed);
                    }
                }
                if (completedFlows != null) {
                    ArrayNode completedSequenceFlows = displayNode.putArray("completedSequenceFlows");
                    for (String current : completedFlows) {
                        completedSequenceFlows.add(current);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error creating model JSON", (Throwable)e);
            }
        }
        return displayNode;
    }

    protected List<String> gatherCompletedFlows(List<String> completedActivityInstances, List<String> currentActivityinstances, BpmnModel pojoModel) {
        ArrayList<String> completedFlows = new ArrayList<String>();
        ArrayList<String> activities = new ArrayList<String>(completedActivityInstances);
        if (currentActivityinstances != null) {
            activities.addAll(currentActivityinstances);
        }
        for (FlowElement activity : pojoModel.getMainProcess().getFlowElements()) {
            int index;
            if (!(activity instanceof FlowNode) || (index = activities.indexOf(activity.getId())) < 0 || index + 1 >= activities.size()) continue;
            List outgoingFlows = ((FlowNode)activity).getOutgoingFlows();
            for (SequenceFlow flow : outgoingFlows) {
                String destinationFlowId = flow.getTargetRef();
                if (!destinationFlowId.equals(activities.get(index + 1))) continue;
                completedFlows.add(flow.getId());
            }
        }
        return completedFlows;
    }

    protected void processProcessElements(ServerConfig config, BpmnModel pojoModel, ObjectNode displayNode, GraphicInfo diagramInfo, Set<String> completedElements, Set<String> currentElements) throws Exception {
        if (pojoModel.getLocationMap().isEmpty()) {
            return;
        }
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode flowArray = this.objectMapper.createArrayNode();
        ArrayNode collapsedArray = this.objectMapper.createArrayNode();
        if (CollectionUtils.isNotEmpty((Collection)pojoModel.getPools())) {
            ArrayNode poolArray = this.objectMapper.createArrayNode();
            boolean firstElement = true;
            for (Pool pool : pojoModel.getPools()) {
                ObjectNode poolNode = this.objectMapper.createObjectNode();
                poolNode.put("id", pool.getId());
                poolNode.put("name", pool.getName());
                GraphicInfo poolInfo = pojoModel.getGraphicInfo(pool.getId());
                this.fillGraphicInfo(poolNode, poolInfo, true);
                Process process = pojoModel.getProcess(pool.getId());
                if (process != null && CollectionUtils.isNotEmpty((Collection)process.getLanes())) {
                    ArrayNode laneArray = this.objectMapper.createArrayNode();
                    for (Lane lane : process.getLanes()) {
                        ObjectNode laneNode = this.objectMapper.createObjectNode();
                        laneNode.put("id", lane.getId());
                        laneNode.put("name", lane.getName());
                        this.fillGraphicInfo(laneNode, pojoModel.getGraphicInfo(lane.getId()), true);
                        laneArray.add((JsonNode)laneNode);
                    }
                    poolNode.set("lanes", (JsonNode)laneArray);
                }
                poolArray.add((JsonNode)poolNode);
                double rightX = poolInfo.getX() + poolInfo.getWidth();
                double bottomY = poolInfo.getY() + poolInfo.getHeight();
                double middleX = poolInfo.getX() + poolInfo.getWidth() / 2.0;
                if (firstElement || middleX < diagramInfo.getX()) {
                    diagramInfo.setX(middleX);
                }
                if (firstElement || poolInfo.getY() < diagramInfo.getY()) {
                    diagramInfo.setY(poolInfo.getY());
                }
                if (rightX > diagramInfo.getWidth()) {
                    diagramInfo.setWidth(rightX);
                }
                if (bottomY > diagramInfo.getHeight()) {
                    diagramInfo.setHeight(bottomY);
                }
                firstElement = false;
            }
            displayNode.set("pools", (JsonNode)poolArray);
        } else {
            diagramInfo.setX(9999.0);
            diagramInfo.setY(1000.0);
        }
        for (Process process : pojoModel.getProcesses()) {
            this.processElements(process.getFlowElements(), pojoModel, elementArray, flowArray, collapsedArray, diagramInfo, completedElements, currentElements, null);
            this.processArtifacts(process.getArtifacts(), pojoModel, elementArray, flowArray, diagramInfo);
        }
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)flowArray);
        displayNode.set("collapsed", (JsonNode)collapsedArray);
    }

    protected void processElements(Collection<FlowElement> elementList, BpmnModel model, ArrayNode elementArray, ArrayNode flowArray, ArrayNode collapsedArray, GraphicInfo diagramInfo, Set<String> completedElements, Set<String> currentElements, ObjectNode collapsedNode) {
        for (FlowElement element : elementList) {
            ServiceTask serviceTask;
            GraphicInfo graphicInfo;
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            if (completedElements != null) {
                elementNode.put("completed", completedElements.contains(element.getId()));
            }
            if (currentElements != null) {
                elementNode.put("current", currentElements.contains(element.getId()));
            }
            if (element instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)element;
                elementNode.put("id", flow.getId());
                elementNode.put("type", "sequenceFlow");
                elementNode.put("sourceRef", flow.getSourceRef());
                elementNode.put("targetRef", flow.getTargetRef());
                elementNode.put("name", flow.getName());
                List flowInfo = model.getFlowLocationGraphicInfo(flow.getId());
                ArrayNode waypointArray = this.objectMapper.createArrayNode();
                for (GraphicInfo graphicInfo2 : flowInfo) {
                    ObjectNode pointNode = this.objectMapper.createObjectNode();
                    this.fillGraphicInfo(pointNode, graphicInfo2, false);
                    waypointArray.add((JsonNode)pointNode);
                    this.fillDiagramInfo(graphicInfo2, diagramInfo);
                }
                elementNode.set("waypoints", (JsonNode)waypointArray);
                if (collapsedNode != null) {
                    ((ArrayNode)collapsedNode.get("flows")).add((JsonNode)elementNode);
                    continue;
                }
                flowArray.add((JsonNode)elementNode);
                continue;
            }
            elementNode.put("id", element.getId());
            elementNode.put("name", element.getName());
            if (element instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)element;
                ArrayNode incomingFlows = this.objectMapper.createArrayNode();
                for (SequenceFlow flow : flowNode.getIncomingFlows()) {
                    incomingFlows.add(flow.getId());
                }
                elementNode.set("incomingFlows", (JsonNode)incomingFlows);
            }
            if ((graphicInfo = model.getGraphicInfo(element.getId())) != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            String className = element.getClass().getSimpleName();
            elementNode.put("type", className);
            this.fillEventTypes(className, element, elementNode);
            if (element instanceof ServiceTask && "mail".equals((serviceTask = (ServiceTask)element).getType())) {
                elementNode.put("taskType", "mail");
            }
            if (this.propertyMappers.containsKey(className)) {
                elementNode.set("properties", (JsonNode)this.propertyMappers.get(className).map(element));
            }
            if (collapsedNode != null) {
                ((ArrayNode)collapsedNode.get("elements")).add((JsonNode)elementNode);
            } else {
                elementArray.add((JsonNode)elementNode);
            }
            if (!(element instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)element;
            ObjectNode newCollapsedNode = collapsedNode;
            if (graphicInfo != null && graphicInfo.getExpanded() != null && !graphicInfo.getExpanded().booleanValue()) {
                elementNode.put("collapsed", "true");
                newCollapsedNode = this.objectMapper.createObjectNode();
                newCollapsedNode.put("id", subProcess.getId());
                newCollapsedNode.putArray("elements");
                newCollapsedNode.putArray("flows");
                collapsedArray.add((JsonNode)newCollapsedNode);
            }
            this.processElements(subProcess.getFlowElements(), model, elementArray, flowArray, collapsedArray, diagramInfo, completedElements, currentElements, newCollapsedNode);
            this.processArtifacts(subProcess.getArtifacts(), model, elementArray, flowArray, diagramInfo);
        }
    }

    protected void processArtifacts(Collection<Artifact> artifactList, BpmnModel model, ArrayNode elementArray, ArrayNode flowArray, GraphicInfo diagramInfo) {
        for (Artifact artifact : artifactList) {
            GraphicInfo graphicInfo;
            ObjectNode elementNode;
            if (artifact instanceof Association) {
                elementNode = this.objectMapper.createObjectNode();
                Association flow = (Association)artifact;
                elementNode.put("id", flow.getId());
                elementNode.put("type", "association");
                elementNode.put("sourceRef", flow.getSourceRef());
                elementNode.put("targetRef", flow.getTargetRef());
                this.fillWaypoints(flow.getId(), model, elementNode, diagramInfo);
                flowArray.add((JsonNode)elementNode);
                continue;
            }
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", artifact.getId());
            if (artifact instanceof TextAnnotation) {
                TextAnnotation annotation = (TextAnnotation)artifact;
                elementNode.put("text", annotation.getText());
            }
            if ((graphicInfo = model.getGraphicInfo(artifact.getId())) != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            String className = artifact.getClass().getSimpleName();
            elementNode.put("type", className);
            elementArray.add((JsonNode)elementNode);
        }
    }

    protected void fillWaypoints(String id, BpmnModel model, ObjectNode elementNode, GraphicInfo diagramInfo) {
        List flowInfo = model.getFlowLocationGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
            this.fillDiagramInfo(graphicInfo, diagramInfo);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }

    protected void fillEventTypes(String className, FlowElement element, ObjectNode elementNode) {
        Event event;
        if (this.eventElementTypes.contains(className) && CollectionUtils.isNotEmpty((Collection)(event = (Event)element).getEventDefinitions())) {
            EventDefinition eventDef = (EventDefinition)event.getEventDefinitions().get(0);
            ObjectNode eventNode = this.objectMapper.createObjectNode();
            if (eventDef instanceof TimerEventDefinition) {
                TimerEventDefinition timerDef = (TimerEventDefinition)eventDef;
                eventNode.put("type", "timer");
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeCycle())) {
                    eventNode.put("timeCycle", timerDef.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeDate())) {
                    eventNode.put("timeDate", timerDef.getTimeDate());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeDuration())) {
                    eventNode.put("timeDuration", timerDef.getTimeDuration());
                }
            } else if (eventDef instanceof ConditionalEventDefinition) {
                ConditionalEventDefinition conditionalDef = (ConditionalEventDefinition)eventDef;
                eventNode.put("type", "conditional");
                if (StringUtils.isNotEmpty((CharSequence)conditionalDef.getConditionExpression())) {
                    eventNode.put("condition", conditionalDef.getConditionExpression());
                }
            } else if (eventDef instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDef = (ErrorEventDefinition)eventDef;
                eventNode.put("type", "error");
                if (StringUtils.isNotEmpty((CharSequence)errorDef.getErrorCode())) {
                    eventNode.put("errorCode", errorDef.getErrorCode());
                }
            } else if (eventDef instanceof EscalationEventDefinition) {
                EscalationEventDefinition escalationDef = (EscalationEventDefinition)eventDef;
                eventNode.put("type", "escalation");
                if (StringUtils.isNotEmpty((CharSequence)escalationDef.getEscalationCode())) {
                    eventNode.put("escalationCode", escalationDef.getEscalationCode());
                }
            } else if (eventDef instanceof SignalEventDefinition) {
                SignalEventDefinition signalDef = (SignalEventDefinition)eventDef;
                eventNode.put("type", "signal");
                if (StringUtils.isNotEmpty((CharSequence)signalDef.getSignalRef())) {
                    eventNode.put("signalRef", signalDef.getSignalRef());
                }
            } else if (eventDef instanceof MessageEventDefinition) {
                MessageEventDefinition messageDef = (MessageEventDefinition)eventDef;
                eventNode.put("type", "message");
                if (StringUtils.isNotEmpty((CharSequence)messageDef.getMessageRef())) {
                    eventNode.put("messageRef", messageDef.getMessageRef());
                }
            } else if (eventDef instanceof VariableListenerEventDefinition) {
                VariableListenerEventDefinition variableDef = (VariableListenerEventDefinition)eventDef;
                eventNode.put("type", "variable");
                if (StringUtils.isNotEmpty((CharSequence)variableDef.getVariableName())) {
                    eventNode.put("variableName", variableDef.getVariableName());
                }
                if (StringUtils.isNotEmpty((CharSequence)variableDef.getVariableChangeType())) {
                    eventNode.put("variableChangeType", variableDef.getVariableChangeType());
                }
            }
            elementNode.set("eventDefinition", (JsonNode)eventNode);
        }
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }
}

