/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CmmnDeploymentService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/admin/cmmn-deployments"})
public class CmmnDeploymentsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDeploymentsClientResource.class);
    @Autowired
    protected CmmnDeploymentService clientService;

    @GetMapping(produces={"application/json"})
    public JsonNode listCmmnDeployments(HttpServletRequest request) {
        LOGGER.debug("REST request to get a list of CMMN deployments");
        JsonNode resultNode = null;
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            resultNode = this.clientService.listDeployments(serverConfig, parameterMap);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting CMMN deployments", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }

    @PostMapping(produces={"application/json"})
    public JsonNode handleCmmnFileUpload(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        if (!file.isEmpty()) {
            try {
                ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
                String fileName = file.getOriginalFilename();
                if (fileName != null && (fileName.endsWith(".cmmn") || fileName.endsWith(".xml"))) {
                    return this.clientService.uploadDeployment(serverConfig, fileName, file.getInputStream());
                }
                LOGGER.error("Invalid cmmn deployment file name {}", (Object)fileName);
                throw new BadRequestException("Invalid file name");
            }
            catch (IOException e) {
                LOGGER.error("Error deploying CMMN upload", (Throwable)e);
                throw new InternalServerErrorException("Could not deploy file: " + e.getMessage());
            }
        }
        LOGGER.error("No cmmn deployment file found in request");
        throw new BadRequestException("No file found in POST body");
    }
}

