/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.variable.service.impl.types.EntityManagerSessionImpl;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class SpringEntityManagerSessionFactory
implements SessionFactory {
    protected EntityManagerFactory entityManagerFactory;
    protected boolean handleTransactions;
    protected boolean closeEntityManager;

    public SpringEntityManagerSessionFactory(Object entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        this.entityManagerFactory = (EntityManagerFactory)entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    public Class<?> getSessionType() {
        return EntityManagerFactory.class;
    }

    public Session openSession(CommandContext commandContext) {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        if (entityManager == null) {
            return new EntityManagerSessionImpl(this.entityManagerFactory, this.handleTransactions, this.closeEntityManager);
        }
        return new EntityManagerSessionImpl(this.entityManagerFactory, entityManager, false, false);
    }
}

