/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.security;

import java.security.Principal;
import org.flowable.common.engine.api.identity.AuthenticationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityAuthenticationContext
implements AuthenticationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringSecurityAuthenticationContext.class);

    public String getAuthenticatedUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication == null ? null : authentication.getName();
    }

    public Authentication getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public void setPrincipal(Principal principal) {
        if (principal == null) {
            SecurityContextHolder.getContext().setAuthentication(null);
        } else if (principal instanceof Authentication) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)principal);
        } else {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)principal, null));
            LOGGER.debug("Setting a principal that is not of type `org.springframework.security.core.Authentication`. When using Spring Security you can just set the user through 'SecurityContextHolder.getContext().setAuthentication(..)' Using 'org.springframework.security.authentication.UsernamePasswordAuthenticationToken' to wrap the principal of type '{}'", principal.getClass());
        }
    }
}

