/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap;

import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.ldap.LDAPConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConnectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPConnectionUtil.class);

    public static InitialDirContext creatDirectoryContext(LDAPConfiguration ldapConfigurator) {
        return LDAPConnectionUtil.createDirectoryContext(ldapConfigurator, ldapConfigurator.getUser(), ldapConfigurator.getPassword());
    }

    public static InitialDirContext createDirectoryContext(LDAPConfiguration ldapConfigurator, String principal, String credentials) {
        InitialDirContext context;
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", ldapConfigurator.getInitialContextFactory());
        properties.put("java.naming.provider.url", ldapConfigurator.getServer() + ":" + ldapConfigurator.getPort());
        properties.put("java.naming.security.authentication", ldapConfigurator.getSecurityAuthentication());
        properties.put("java.naming.security.principal", principal);
        properties.put("java.naming.security.credentials", credentials);
        if (ldapConfigurator.getCustomConnectionParameters() != null) {
            for (String customParameter : ldapConfigurator.getCustomConnectionParameters().keySet()) {
                properties.put(customParameter, ldapConfigurator.getCustomConnectionParameters().get(customParameter));
            }
        }
        try {
            context = new InitialDirContext(properties);
        }
        catch (NamingException e) {
            LOGGER.warn("Could not create InitialDirContext for LDAP connection: {}", (Object)e.getMessage());
            throw new FlowableException("Could not create InitialDirContext for LDAP connection: " + e.getMessage(), (Throwable)e);
        }
        return context;
    }

    public static void closeDirectoryContext(InitialDirContext initialDirContext) {
        try {
            initialDirContext.close();
        }
        catch (NamingException e) {
            LOGGER.warn("Could not close InitialDirContext correctly!", (Throwable)e);
        }
    }
}

