/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.FindExpiredJobsCmd;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsCmd;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetExpiredJobsRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetExpiredJobsRunnable.class);
    protected final String name;
    protected final AsyncExecutor asyncExecutor;
    protected final Collection<JobInfoEntityManager<? extends JobInfoEntity>> jobInfoEntityManagers;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public ResetExpiredJobsRunnable(String name, AsyncExecutor asyncExecutor, JobInfoEntityManager<? extends JobInfoEntity> ... jobEntityManagers) {
        this.name = name;
        this.asyncExecutor = asyncExecutor;
        if (jobEntityManagers.length < 1) {
            throw new IllegalArgumentException("there must be at least one job entity manager");
        }
        this.jobInfoEntityManagers = Arrays.asList(jobEntityManagers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        LOGGER.info("starting to reset expired jobs for engine {}", (Object)this.getEngineName());
        Thread.currentThread().setName(this.name);
        while (!this.isInterrupted) {
            this.resetJobs();
            try {
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.asyncExecutor.getResetExpiredJobsInterval());
                    }
                }
            }
            catch (InterruptedException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("async reset expired jobs wait for engine {} interrupted", (Object)this.getEngineName());
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        LOGGER.info("stopped resetting expired jobs for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
    }

    public void resetJobs() {
        for (JobInfoEntityManager<? extends JobInfoEntity> jobInfoEntityManager : this.jobInfoEntityManagers) {
            this.resetJobs(jobInfoEntityManager);
        }
    }

    protected void resetJobs(JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        boolean hasExpiredJobs = true;
        while (hasExpiredJobs && !this.isInterrupted) {
            try {
                JobServiceConfiguration jobServiceConfiguration = this.asyncExecutor.getJobServiceConfiguration();
                List expiredJobs = (List)jobServiceConfiguration.getCommandExecutor().execute((Command)new FindExpiredJobsCmd(this.asyncExecutor.getResetExpiredJobsPageSize(), jobEntityManager, jobServiceConfiguration));
                List<String> expiredJobIds = expiredJobs.stream().map(JobInfo::getId).collect(Collectors.toList());
                if (!expiredJobIds.isEmpty()) {
                    this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor().execute((Command)new ResetExpiredJobsCmd(expiredJobIds, jobEntityManager, jobServiceConfiguration));
                    continue;
                }
                hasExpiredJobs = false;
            }
            catch (Throwable e) {
                if (e instanceof FlowableOptimisticLockingException) {
                    LOGGER.debug("Optimistic lock exception while resetting locked jobs for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)e);
                    continue;
                }
                LOGGER.warn("exception during resetting expired jobs: {} for engine {}", new Object[]{e.getMessage(), this.asyncExecutor.getJobServiceConfiguration().getEngineName(), e});
                hasExpiredJobs = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    protected String getEngineName() {
        return this.asyncExecutor.getJobServiceConfiguration().getEngineName();
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }
}

