/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.test.CleanTest;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.engine.test.FormDeploymentAnnotation;
import org.flowable.form.engine.test.FormDeploymentId;
import org.flowable.form.engine.test.FormTestHelper;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableFormExtension
implements AfterEachCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver {
    protected static final String EMPTY_LINE = "\n";
    protected static final String ANNOTATION_DEPLOYMENT_ID_KEY = "deploymentIdFromFormDeploymentAnnotation";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        FormEngine formEngine = this.getFormEngine(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), FormDeploymentAnnotation.class).ifPresent(deployment -> {
            String deploymentIdFromDeploymentAnnotation = FormTestHelper.annotationDeploymentSetUp(formEngine, context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            this.getStore(context).put((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), (Object)deploymentIdFromDeploymentAnnotation);
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_METHOD);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFinally(ExtensionContext context, TestInstance.Lifecycle lifecycleForClean) {
        FormEngine formEngine = this.getFormEngine(context);
        FormEngineConfiguration formEngineConfiguration = formEngine.getFormEngineConfiguration();
        try {
            String annotationDeploymentKey = context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY;
            String deploymentIdFromDeploymentAnnotation = (String)this.getStore(context).get((Object)annotationDeploymentKey, String.class);
            if (deploymentIdFromDeploymentAnnotation != null) {
                FormTestHelper.annotationDeploymentTearDown(formEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
                this.getStore(context).remove((Object)annotationDeploymentKey);
            }
            AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CleanTest.class).ifPresent(cleanTest -> this.removeDeployments(formEngine.getFormRepositoryService()));
            if (context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == lifecycleForClean) {
                this.cleanTestAndAssertAndEnsureCleanDb(context, formEngine);
            }
        }
        finally {
            formEngineConfiguration.getClock().reset();
        }
    }

    protected void cleanTestAndAssertAndEnsureCleanDb(ExtensionContext context, FormEngine formEngine) {
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), CleanTest.class).ifPresent(cleanTest -> this.removeDeployments(this.getFormEngine(context).getFormRepositoryService()));
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> this.assertAndEnsureCleanDb(formEngine, context, (EnsureCleanDb)ensureCleanDb));
    }

    protected void assertAndEnsureCleanDb(FormEngine formEngine, ExtensionContext context, EnsureCleanDb ensureCleanDb) {
        this.logger.debug("verifying that db is clean after test");
        HashSet<String> tableNamesExcludedFromDbCleanCheck = new HashSet<String>(Arrays.asList(ensureCleanDb.excludeTables()));
        FormManagementService managementService = formEngine.getFormManagementService();
        FormEngineConfiguration formEngineConfiguration = formEngine.getFormEngineConfiguration();
        Map tableCounts = managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(formEngineConfiguration.getDatabaseTablePrefix(), "");
            if (tableNamesExcludedFromDbCleanCheck.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            this.logger.error(EMPTY_LINE);
            this.logger.error(outputMessage.toString());
            this.logger.info("dropping and recreating db");
            if (ensureCleanDb.dropDb()) {
                CommandExecutor commandExecutor = formEngineConfiguration.getCommandExecutor();
                CommandConfig config = new CommandConfig().transactionNotSupported();
                commandExecutor.execute(config, (Command)new Command<Object>(){

                    public Object execute(CommandContext commandContext) {
                        SchemaManager schemaManager = CommandContextUtil.getFormEngineConfiguration(commandContext).getSchemaManager();
                        schemaManager.schemaDrop();
                        schemaManager.schemaCreate();
                        return null;
                    }
                });
            }
            if (!context.getExecutionException().isPresent()) {
                throw new AssertionError((Object)outputMessage.toString());
            }
        } else {
            this.logger.info("database was clean");
        }
    }

    protected void removeDeployments(FormRepositoryService repositoryService) {
        for (FormDeployment deployment : repositoryService.createDeploymentQuery().list()) {
            try {
                repositoryService.deleteDeployment(deployment.getId());
            }
            catch (FlowableOptimisticLockingException flowableOptimisticLockingException) {
                this.logger.warn("Caught exception, retrying", (Throwable)flowableOptimisticLockingException);
                repositoryService.deleteDeployment(deployment.getId());
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return FormEngine.class.equals(parameterType) || parameterContext.isAnnotated(FormDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        if (parameterContext.isAnnotated(FormDeploymentId.class)) {
            return this.getStore(context).get((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        }
        return this.getFormEngine(context);
    }

    protected abstract FormEngine getFormEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

