/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.rest.service.api.repository.BaseEventDefinitionResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Definitions"}, description="Manage Event Definitions", authorizations={@Authorization(value="basicAuth")})
public class EventDefinitionModelResource
extends BaseEventDefinitionResource {
    @ApiOperation(value="Get an event definition JSPN model", tags={"Event Definitions"}, nickname="getEventModelResource")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the event definition was found and the model is returned. The response contains the full event definition model."), @ApiResponse(code=404, message="Indicates the requested event definition was not found.")})
    @GetMapping(value={"/event-registry-repository/event-definitions/{eventDefinitionId}/model"}, produces={"application/json"})
    public EventModel getModelResource(@ApiParam(name="eventDefinitionId") @PathVariable String eventDefinitionId) {
        EventDefinition eventDefinition = this.getEventDefinitionFromRequest(eventDefinitionId);
        return this.repositoryService.getEventModelById(eventDefinition.getId());
    }
}

