/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.rest.service.api.repository.BaseEventDefinitionResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Channel Definitions"}, description="Manage Channel Definitions", authorizations={@Authorization(value="basicAuth")})
public class ChannelDefinitionModelResource
extends BaseEventDefinitionResource {
    @ApiOperation(value="Get a channel definition JSPN model", tags={"Channel Definitions"}, nickname="getChannelModelResource")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the event definition was found and the model is returned. The response contains the full event definition model."), @ApiResponse(code=404, message="Indicates the requested event definition was not found.")})
    @GetMapping(value={"/event-registry-repository/channel-definitions/{channelDefinitionId}/model"}, produces={"application/json"})
    public ChannelModel getModelResource(@ApiParam(name="channelDefinitionId") @PathVariable String channelDefinitionId) {
        ChannelDefinition channelDefinition = this.getChannelDefinitionFromRequest(channelDefinitionId);
        return this.repositoryService.getChannelModelById(channelDefinition.getId());
    }
}

