/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.cmd.CompleteTaskCmd;
import org.flowable.engine.impl.cmd.CompleteTaskWithFormCmd;
import org.flowable.task.api.TaskCompletionBuilder;

public class TaskCompletionBuilderImpl
implements TaskCompletionBuilder {
    protected CommandExecutor commandExecutor;
    protected String taskId;
    protected String formDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected Map<String, Object> variablesLocal;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> transientVariablesLocal;

    public TaskCompletionBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public TaskCompletionBuilder variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public TaskCompletionBuilder variablesLocal(Map<String, Object> variablesLocal) {
        this.variablesLocal = variablesLocal;
        return this;
    }

    public TaskCompletionBuilder transientVariables(Map<String, Object> transientVariables) {
        this.transientVariables = transientVariables;
        return this;
    }

    public TaskCompletionBuilder transientVariablesLocal(Map<String, Object> transientVariablesLocal) {
        this.transientVariablesLocal = transientVariablesLocal;
        return this;
    }

    public TaskCompletionBuilder variable(String variableName, Object variableValue) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, variableValue);
        return this;
    }

    public TaskCompletionBuilder variableLocal(String variableName, Object variableValue) {
        if (this.variablesLocal == null) {
            this.variablesLocal = new HashMap<String, Object>();
        }
        this.variablesLocal.put(variableName, variableValue);
        return this;
    }

    public TaskCompletionBuilder transientVariable(String variableName, Object variableValue) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(variableName, variableValue);
        return this;
    }

    public TaskCompletionBuilder transientVariableLocal(String variableName, Object variableValue) {
        if (this.transientVariablesLocal == null) {
            this.transientVariablesLocal = new HashMap<String, Object>();
        }
        this.transientVariablesLocal.put(variableName, variableValue);
        return this;
    }

    public TaskCompletionBuilder taskId(String id) {
        this.taskId = id;
        return this;
    }

    public TaskCompletionBuilder formDefinitionId(String formDefinitionId) {
        this.formDefinitionId = formDefinitionId;
        return this;
    }

    public TaskCompletionBuilder outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    protected void completeTask() {
        this.commandExecutor.execute((Command)new CompleteTaskCmd(this.taskId, this.variables, this.variablesLocal, this.transientVariables, this.transientVariablesLocal));
    }

    protected void completeTaskWithForm() {
        this.commandExecutor.execute((Command)new CompleteTaskWithFormCmd(this.taskId, this.formDefinitionId, this.outcome, this.variables, this.variablesLocal, this.transientVariables, this.transientVariablesLocal));
    }

    public void complete() {
        if (this.formDefinitionId != null) {
            this.completeTaskWithForm();
        } else {
            this.completeTask();
        }
    }
}

