/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;

public class VariableContainerELResolver
extends ELResolver {
    public static final String VARIABLE_CONTAINER_KEY = "variableContainer";
    public static final String LOGGED_IN_USER_KEY = "authenticatedUserId";
    protected VariableContainer variableContainer;

    public VariableContainerELResolver(VariableContainer variableContainer) {
        this.variableContainer = variableContainer;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            if (LOGGED_IN_USER_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return Authentication.getAuthenticatedUserId();
            }
            if (this.variableContainer.hasVariable(variable)) {
                context.setPropertyResolved(true);
                return this.variableContainer.getVariable(variable);
            }
            if (VARIABLE_CONTAINER_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return this.variableContainer;
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            return !this.variableContainer.hasVariable(variable);
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        String variable;
        if (base == null && this.variableContainer.hasVariable(variable = (String)property)) {
            context.setPropertyResolved(true);
            this.variableContainer.setVariable(variable, value);
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    @Override
    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }
}

