/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.UnaryTests;

public class OutputValuesParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "outputValues";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable) throws Exception {
        if (!(parentElement instanceof OutputClause)) {
            return;
        }
        OutputClause clause = (OutputClause)parentElement;
        UnaryTests outputValues = new UnaryTests();
        boolean readyWithOutputValues = false;
        try {
            while (!readyWithOutputValues && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    String outputValuesText = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)outputValuesText)) continue;
                    String[] outputValuesSplit = outputValuesText.replaceAll("^\"", "").split("\"?(,|$)(?=(([^\"]*\"){2})*[^\"]*$) *\"?");
                    outputValues.setTextValues(new ArrayList<String>(Arrays.asList(outputValuesSplit)));
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithOutputValues = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing output values", (Throwable)e);
        }
        clause.setOutputValues(outputValues);
    }
}

