/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.test;

import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.flowable.dmn.engine.impl.test.AbstractFlowableDmnTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceFlowableDmnTestCase
extends AbstractFlowableDmnTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFlowableDmnTestCase.class);
    protected String flowableConfigurationResource;
    protected String dmnEngineName;

    public ResourceFlowableDmnTestCase(String flowableConfigurationResource) {
        this(flowableConfigurationResource, null);
    }

    public ResourceFlowableDmnTestCase(String flowableConfigurationResource, String dmnEngineName) {
        this.flowableConfigurationResource = flowableConfigurationResource;
        this.dmnEngineName = dmnEngineName;
    }

    @Override
    protected void closeDownDmnEngine() {
        super.closeDownDmnEngine();
        DmnEngines.unregister(this.dmnEngine);
        this.dmnEngine = null;
        this.nullifyServices();
    }

    @Override
    protected void initializeDmnEngine() {
        DmnEngineConfiguration config = DmnEngineConfiguration.createDmnEngineConfigurationFromResource(this.flowableConfigurationResource);
        if (this.dmnEngineName != null) {
            LOGGER.info("Initializing DMN engine with name '{}'", (Object)this.dmnEngineName);
            config.setEngineName(this.dmnEngineName);
        }
        this.additionalConfiguration(config);
        this.dmnEngine = config.buildDmnEngine();
    }

    protected void additionalConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
    }
}

