/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DecisionServiceExecutionAuditContainer;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.cmd.EvaluateDecisionCmd;
import org.flowable.dmn.engine.impl.cmd.ExecuteDecisionCmd;
import org.flowable.dmn.engine.impl.cmd.ExecuteDecisionServiceCmd;
import org.flowable.dmn.engine.impl.cmd.ExecuteDecisionWithAuditTrailCmd;
import org.flowable.dmn.engine.impl.cmd.PersistHistoricDecisionExecutionCmd;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnElementReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDecisionServiceImpl
extends CommonEngineServiceImpl<DmnEngineConfiguration>
implements DmnDecisionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDecisionServiceImpl.class);

    public DmnDecisionServiceImpl(DmnEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public ExecuteDecisionBuilder createExecuteDecisionBuilder() {
        return new ExecuteDecisionBuilderImpl(this);
    }

    public List<Map<String, Object>> executeDecision(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionCmd(executeDecisionContext));
        List<Map<String, Object>> decisionResult = this.composeDecisionResult(executeDecisionContext);
        this.persistDecisionAudit(executeDecisionContext);
        return decisionResult;
    }

    public Map<String, List<Map<String, Object>>> executeDecisionService(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionServiceCmd(executeDecisionContext));
        Map<String, List<Map<String, Object>>> decisionResult = this.composeDecisionServiceResult(executeDecisionContext);
        this.persistDecisionAudit(executeDecisionContext);
        return decisionResult;
    }

    public Map<String, Object> executeWithSingleResult(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new EvaluateDecisionCmd(executeDecisionContext));
        HashMap<String, Object> singleDecisionResult = null;
        Map<String, List<Map<String, Object>>> decisionResult = this.composeEvaluateDecisionResult(executeDecisionContext);
        this.persistDecisionAudit(executeDecisionContext);
        for (Map.Entry<String, List<Map<String, Object>>> entry : decisionResult.entrySet()) {
            List<Map<String, Object>> decisionResults = entry.getValue();
            if (decisionResults == null || decisionResults.isEmpty()) continue;
            if (decisionResults.size() > 1) {
                throw new FlowableException("more than one result in decision: " + entry.getKey());
            }
            if (singleDecisionResult == null) {
                singleDecisionResult = new HashMap<String, Object>();
            }
            singleDecisionResult.putAll(decisionResults.get(0));
        }
        return singleDecisionResult;
    }

    public Map<String, Object> executeDecisionWithSingleResult(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionCmd(executeDecisionContext));
        Map<String, Object> singleDecisionResult = null;
        List<Map<String, Object>> decisionResult = this.composeDecisionResult(executeDecisionContext);
        this.persistDecisionAudit(executeDecisionContext);
        if (decisionResult != null && !decisionResult.isEmpty()) {
            if (decisionResult.size() > 1) {
                throw new FlowableException("more than one result");
            }
            singleDecisionResult = decisionResult.get(0);
        }
        return singleDecisionResult;
    }

    public Map<String, Object> executeDecisionServiceWithSingleResult(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionServiceCmd(executeDecisionContext));
        HashMap<String, Object> singleDecisionResult = new HashMap<String, Object>();
        Map<String, List<Map<String, Object>>> decisionResult = this.composeDecisionServiceResult(executeDecisionContext);
        this.persistDecisionAudit(executeDecisionContext);
        for (Map.Entry<String, List<Map<String, Object>>> entry : decisionResult.entrySet()) {
            List<Map<String, Object>> decisionResults = entry.getValue();
            if (decisionResults == null || decisionResults.isEmpty()) continue;
            if (decisionResults.size() > 1) {
                throw new FlowableException("more than one result in decision: " + entry.getKey());
            }
            singleDecisionResult.putAll(decisionResults.get(0));
        }
        return singleDecisionResult;
    }

    public DecisionExecutionAuditContainer executeWithAuditTrail(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new EvaluateDecisionCmd(executeDecisionContext));
        this.composeEvaluateDecisionResult(executeDecisionContext);
        DecisionExecutionAuditContainer decisionExecution = this.persistDecisionAudit(executeDecisionContext);
        return decisionExecution;
    }

    public DecisionExecutionAuditContainer executeDecisionWithAuditTrail(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionWithAuditTrailCmd(executeDecisionContext));
        this.composeDecisionResult(executeDecisionContext);
        DecisionExecutionAuditContainer decisionExecution = this.persistDecisionAudit(executeDecisionContext);
        return decisionExecution;
    }

    public DecisionServiceExecutionAuditContainer executeDecisionServiceWithAuditTrail(ExecuteDecisionBuilder builder) {
        ExecuteDecisionContext executeDecisionContext = builder.buildExecuteDecisionContext();
        this.commandExecutor.execute((Command)new ExecuteDecisionServiceCmd(executeDecisionContext));
        this.composeDecisionServiceResult(executeDecisionContext);
        DecisionServiceExecutionAuditContainer decisionServiceExecutionAuditContainer = (DecisionServiceExecutionAuditContainer)this.persistDecisionAudit(executeDecisionContext);
        return decisionServiceExecutionAuditContainer;
    }

    protected Map<String, List<Map<String, Object>>> composeEvaluateDecisionResult(ExecuteDecisionContext executeDecisionContext) {
        Map<String, List<Map<String, Object>>> result;
        if (executeDecisionContext.getDmnElement() instanceof DecisionService) {
            result = this.composeDecisionServiceResult(executeDecisionContext);
        } else if (executeDecisionContext.getDmnElement() instanceof Decision) {
            result = new HashMap<String, List<Map<String, Object>>>();
            result.put(executeDecisionContext.getDecisionKey(), executeDecisionContext.getDecisionExecution().getDecisionResult());
        } else {
            LOGGER.error("Execution was not a decision or decision service");
            throw new FlowableException("Execution was not a decision or decision service");
        }
        return result;
    }

    protected List<Map<String, Object>> composeDecisionResult(ExecuteDecisionContext executeDecisionContext) {
        return executeDecisionContext.getDecisionExecution().getDecisionResult();
    }

    protected Map<String, List<Map<String, Object>>> composeDecisionServiceResult(ExecuteDecisionContext executeDecisionContext) {
        if (executeDecisionContext.getDmnElement() instanceof DecisionService) {
            HashMap<String, List<Map<String, Object>>> decisionServiceResult = new HashMap<String, List<Map<String, Object>>>();
            DecisionService decisionService = (DecisionService)executeDecisionContext.getDmnElement();
            DecisionServiceExecutionAuditContainer decisionServiceExecutionAuditContainer = (DecisionServiceExecutionAuditContainer)executeDecisionContext.getDecisionExecution();
            boolean multipleResults = decisionService.getOutputDecisions().size() > 1;
            for (DmnElementReference elementReference : decisionService.getOutputDecisions()) {
                DecisionExecutionAuditContainer childDecisionExecution = decisionServiceExecutionAuditContainer.getChildDecisionExecution(elementReference.getParsedId());
                if (childDecisionExecution.getDecisionResult() != null && !childDecisionExecution.getDecisionResult().isEmpty()) {
                    decisionServiceResult.put(elementReference.getParsedId(), childDecisionExecution.getDecisionResult());
                }
                multipleResults = multipleResults || childDecisionExecution.isMultipleResults();
            }
            decisionServiceExecutionAuditContainer.setDecisionServiceResult(decisionServiceResult);
            decisionServiceExecutionAuditContainer.setMultipleResults(multipleResults);
            return decisionServiceResult;
        }
        throw new FlowableException("Main execution was a not a decision service");
    }

    protected DecisionExecutionAuditContainer persistDecisionAudit(ExecuteDecisionContext executeDecisionContext) {
        DecisionExecutionAuditContainer decisionExecution = executeDecisionContext.getDecisionExecution();
        decisionExecution.stopAudit();
        this.commandExecutor.execute((Command)new PersistHistoricDecisionExecutionCmd(executeDecisionContext));
        return decisionExecution;
    }
}

