/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntity;
import org.flowable.content.engine.impl.util.CommandContextUtil;

public class DeleteContentItemCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String contentItemId;

    public DeleteContentItemCmd(String contentItemId) {
        this.contentItemId = contentItemId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.contentItemId == null) {
            throw new FlowableIllegalArgumentException("contentItemId is null");
        }
        ContentItemEntity contentItem = (ContentItemEntity)CommandContextUtil.getContentItemEntityManager().findById(this.contentItemId);
        if (contentItem == null) {
            throw new FlowableObjectNotFoundException("content item could not be found with id " + this.contentItemId);
        }
        if (contentItem.getContentStoreId() != null) {
            ContentStorage contentStorage = CommandContextUtil.getContentEngineConfiguration().getContentStorage();
            if (contentItem.isContentAvailable()) {
                contentStorage.deleteContentObject(contentItem.getContentStoreId());
            }
        }
        CommandContextUtil.getContentItemEntityManager().delete(contentItem);
        return null;
    }
}

