/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring.configurator;

import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.configurator.CmmnEngineConfigurator;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringCmmnEngineConfigurator
extends CmmnEngineConfigurator {
    public void configure(AbstractEngineConfiguration engineConfiguration) {
        JobServiceConfiguration engineJobServiceConfiguration;
        if (this.cmmnEngineConfiguration == null) {
            this.cmmnEngineConfiguration = new SpringCmmnEngineConfiguration();
        }
        if (!(this.cmmnEngineConfiguration instanceof SpringCmmnEngineConfiguration)) {
            throw new FlowableException("SpringCmmnEngineConfigurator accepts only SpringCmmnEngineConfiguration. " + this.cmmnEngineConfiguration.getClass().getName());
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
        SpringEngineConfiguration springEngineConfiguration = (SpringEngineConfiguration)engineConfiguration;
        SpringProcessEngineConfiguration springProcessEngineConfiguration = null;
        if (springEngineConfiguration instanceof SpringProcessEngineConfiguration) {
            springProcessEngineConfiguration = (SpringProcessEngineConfiguration)springEngineConfiguration;
        } else {
            AbstractEngineConfiguration processEngineConfiguration = (AbstractEngineConfiguration)engineConfiguration.getEngineConfigurations().get("cfg.processEngine");
            if (processEngineConfiguration instanceof SpringProcessEngineConfiguration) {
                springProcessEngineConfiguration = (SpringProcessEngineConfiguration)processEngineConfiguration;
            }
        }
        if (springProcessEngineConfiguration != null) {
            this.copyProcessEngineProperties((ProcessEngineConfigurationImpl)springProcessEngineConfiguration);
        }
        ((SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration).setTransactionManager(springEngineConfiguration.getTransactionManager());
        if (this.cmmnEngineConfiguration.getBeans() == null) {
            this.cmmnEngineConfiguration.setBeans(springEngineConfiguration.getBeans());
        }
        this.initCmmnEngine();
        if (springProcessEngineConfiguration != null) {
            this.cmmnEngineConfiguration.getJobServiceConfiguration().getInternalJobManager().registerScopedInternalJobManager("bpmn", springProcessEngineConfiguration.getJobServiceConfiguration().getInternalJobManager());
            springProcessEngineConfiguration.getJobServiceConfiguration().getInternalJobManager().registerScopedInternalJobManager("cmmn", this.cmmnEngineConfiguration.getJobServiceConfiguration().getInternalJobManager());
        }
        if ((engineJobServiceConfiguration = this.getJobServiceConfiguration(engineConfiguration)) != null) {
            engineJobServiceConfiguration.getInternalJobManager().registerScopedInternalJobManager("cmmn", this.cmmnEngineConfiguration.getJobServiceConfiguration().getInternalJobManager());
        }
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
    }

    protected synchronized CmmnEngine initCmmnEngine() {
        if (this.cmmnEngineConfiguration == null) {
            throw new FlowableException("CmmnEngineConfiguration is required");
        }
        return this.cmmnEngineConfiguration.buildCmmnEngine();
    }

    public SpringCmmnEngineConfiguration getCmmnEngineConfiguration() {
        return (SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration;
    }

    public SpringCmmnEngineConfigurator setCmmnEngineConfiguration(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        return this;
    }
}

