/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskVariableBaseResource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Task Variables"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskVariableDataResource
extends TaskVariableBaseResource {
    @ApiOperation(value="Get the binary data for a variable", tags={"Task Variables"}, nickname="getTaskVariableData", notes="The response body contains the binary value of the variable. When the variable is of type binary, the content-type of the response is set to application/octet-stream, regardless of the content of the variable or the request accept-type header. In case of serializable, application/x-java-serialized-object is used as content-type.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="scope", dataType="string", value="Scope of variable to be returned. When local, only task-local variable value is returned. When global, only variable value from the task\u2019s parent execution-hierarchy are returned. When the parameter is omitted, a local variable will be returned if it exists, otherwise a global variable.", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the requested variables are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task does not have a variable with the given name (in the given scope). Status message provides additional information.")})
    @GetMapping(value={"/cmmn-runtime/tasks/{taskId}/variables/{variableName}/data"}, produces={"application/json"})
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @ApiParam(hidden=true) @RequestParam(value="scope", required=false) String scope, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(taskId, variableName, scope, true);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected error getting variable data", (Throwable)ioe);
        }
    }
}

