/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.common.rest.util.DateToStringSerializer;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;

public class TaskResponse {
    protected String id;
    protected String url;
    protected String owner;
    protected String assignee;
    protected String delegationState;
    protected String name;
    protected String description;
    @JsonSerialize(using=DateToStringSerializer.class, as=Date.class)
    protected Date createTime;
    @JsonSerialize(using=DateToStringSerializer.class, as=Date.class)
    protected Date dueDate;
    protected int priority;
    protected boolean suspended;
    @JsonSerialize(using=DateToStringSerializer.class, as=Date.class)
    protected Date claimTime;
    protected String taskDefinitionKey;
    protected String scopeDefinitionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String propagatedStageInstanceId;
    protected String tenantId;
    protected String category;
    protected String formKey;
    protected String caseInstanceId;
    protected String caseInstanceUrl;
    protected String caseDefinitionId;
    protected String caseDefinitionUrl;
    protected String parentTaskId;
    protected String parentTaskUrl;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected List<RestVariable> variables = new ArrayList<RestVariable>();

    public TaskResponse(Task task) {
        this.setId(task.getId());
        this.setOwner(task.getOwner());
        this.setAssignee(task.getAssignee());
        this.setDelegationState(this.getDelegationStateString(task.getDelegationState()));
        this.setName(task.getName());
        this.setDescription(task.getDescription());
        this.setCreateTime(task.getCreateTime());
        this.setDueDate(task.getDueDate());
        this.setPriority(task.getPriority());
        this.setSuspended(task.isSuspended());
        this.setClaimTime(task.getClaimTime());
        this.setTaskDefinitionKey(task.getTaskDefinitionKey());
        this.setParentTaskId(task.getParentTaskId());
        this.setCategory(task.getCategory());
        if ("cmmn".equals(task.getScopeType())) {
            this.setCaseInstanceId(task.getScopeId());
            this.setCaseDefinitionId(task.getScopeDefinitionId());
        }
        this.setScopeDefinitionId(task.getScopeDefinitionId());
        this.setScopeId(task.getScopeId());
        this.setSubScopeId(task.getSubScopeId());
        this.setScopeType(task.getScopeType());
        this.setPropagatedStageInstanceId(task.getPropagatedStageInstanceId());
        this.setTenantId(task.getTenantId());
        this.setFormKey(task.getFormKey());
        this.setExecutionId(task.getExecutionId());
        this.setProcessInstanceId(task.getProcessInstanceId());
        this.setProcessDefinitionId(task.getProcessDefinitionId());
    }

    protected String getDelegationStateString(DelegationState state) {
        String result = null;
        if (state != null) {
            result = state.toString().toLowerCase();
        }
        return result;
    }

    @ApiModelProperty(example="8")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="http://localhost:8182/cmmn-runtime/tasks/8")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(example="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @ApiModelProperty(example="kermit")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @ApiModelProperty(example="pending", value="Delegation-state of the task, can be null, \"pending\" or \"resolved\".")
    public String getDelegationState() {
        return this.delegationState;
    }

    public void setDelegationState(String delegationState) {
        this.delegationState = delegationState;
    }

    @ApiModelProperty(example="My task")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="Task description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="2013-04-17T10:17:43.902+0000")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @ApiModelProperty(example="2013-04-17T10:17:43.902+0000")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @ApiModelProperty(example="50")
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    @ApiModelProperty(example="2018-04-17T10:17:43.902+0000", dataType="string")
    public Date getClaimTime() {
        return this.claimTime;
    }

    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }

    @ApiModelProperty(example="theTask")
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @ApiModelProperty(example="123")
    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public void setScopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
    }

    @ApiModelProperty(example="123")
    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    @ApiModelProperty(example="123")
    public String getSubScopeId() {
        return this.subScopeId;
    }

    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    @ApiModelProperty(example="cmmn")
    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    @ApiModelProperty(example="null")
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @ApiModelProperty(example="null")
    public String getParentTaskUrl() {
        return this.parentTaskUrl;
    }

    public void setParentTaskUrl(String parentTaskUrl) {
        this.parentTaskUrl = parentTaskUrl;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @ApiModelProperty(example="ExampleCategory")
    public String getCategory() {
        return this.category;
    }

    @ApiModelProperty(example="5")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @ApiModelProperty(example="http://localhost:8182/cmmn-runtime/case-instances/5")
    public String getCaseInstanceUrl() {
        return this.caseInstanceUrl;
    }

    public void setCaseInstanceUrl(String caseInstanceUrl) {
        this.caseInstanceUrl = caseInstanceUrl;
    }

    @ApiModelProperty(example="oneTaskCase%3A1%3A4")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @ApiModelProperty(example="http://localhost:8182/cmmn-runtime/case-definitions/oneTaskCase%3A1%3A4")
    public String getCaseDefinitionUrl() {
        return this.caseDefinitionUrl;
    }

    public void setCaseDefinitionUrl(String caseDefinitionUrl) {
        this.caseDefinitionUrl = caseDefinitionUrl;
    }

    public List<RestVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<RestVariable> variables) {
        this.variables = variables;
    }

    public void addVariable(RestVariable variable) {
        this.variables.add(variable);
    }

    @ApiModelProperty(example="null")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @ApiModelProperty(example="123")
    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    public void setPropagatedStageInstanceId(String propagatedStageInstanceId) {
        this.propagatedStageInstanceId = propagatedStageInstanceId;
    }

    @ApiModelProperty(example="123")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @ApiModelProperty(example="123")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @ApiModelProperty(example="123")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }
}

