/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDeploymentResourceDataResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected CmmnRepositoryService repositoryService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    protected byte[] getDeploymentResourceData(String deploymentId, String resourceName, HttpServletResponse response) {
        List resourceList;
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("No resource name provided");
        }
        CmmnDeployment deployment = (CmmnDeployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", CmmnDeployment.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        if ((resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId)).contains(resourceName)) {
            InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
            String contentType = null;
            contentType = resourceName.toLowerCase().endsWith(".cmmn") ? ContentType.TEXT_XML.getMimeType() : this.contentTypeResolver.resolveContentType(resourceName);
            response.setContentType(contentType);
            try {
                return IOUtils.toByteArray((InputStream)resourceStream);
            }
            catch (Exception e) {
                throw new FlowableException("Error converting resource stream", (Throwable)e);
            }
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with name '" + resourceName + "' in deployment '" + deploymentId + "'.", String.class);
    }
}

