/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public class HumanTaskJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        HumanTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        HumanTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("HumanTask", HumanTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(HumanTask.class, HumanTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "HumanTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        PlanItem planItem = (PlanItem)baseElement;
        HumanTask humanTask = (HumanTask)planItem.getPlanItemDefinition();
        String assignee = humanTask.getAssignee();
        this.convertAssignmentSettings(propertiesNode, humanTask, assignee);
        if (humanTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", humanTask.getPriority(), propertiesNode);
        }
        if (StringUtils.isNotEmpty((CharSequence)humanTask.getFormKey())) {
            Map<String, String> modelInfo = converterContext.getFormModelInfoForFormModelKey(humanTask.getFormKey());
            if (modelInfo != null) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                formRefNode.put("id", modelInfo.get("id"));
                formRefNode.put("name", modelInfo.get("name"));
                formRefNode.put("key", modelInfo.get("key"));
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", humanTask.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("duedatedefinition", humanTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categorydefinition", humanTask.getCategory(), propertiesNode);
        this.setPropertyValue("taskidvariablename", humanTask.getTaskIdVariableName(), propertiesNode);
        this.convertTaskListenersToJson(propertiesNode, humanTask);
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)humanTask);
    }

    protected void convertAssignmentSettings(ObjectNode propertiesNode, HumanTask humanTask, String assignee) {
        if (StringUtils.isNotEmpty((CharSequence)assignee) || CollectionUtils.isNotEmpty(humanTask.getCandidateUsers()) || CollectionUtils.isNotEmpty(humanTask.getCandidateGroups())) {
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            List idmAssigneeList = (List)humanTask.getExtensionElements().get("flowable-idm-assignee");
            if (CollectionUtils.isNotEmpty(idmAssigneeList) || CollectionUtils.isNotEmpty((Collection)humanTask.getExtensionElements().get("flowable-idm-candidate-user")) || CollectionUtils.isNotEmpty((Collection)humanTask.getExtensionElements().get("flowable-idm-candidate-group"))) {
                assignmentValuesNode.put("type", "idm");
                ObjectNode idmNode = this.objectMapper.createObjectNode();
                assignmentValuesNode.set("idm", (JsonNode)idmNode);
                List canCompleteList = (List)humanTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty(canCompleteList)) {
                    assignmentValuesNode.put("initiatorCanCompleteTask", Boolean.valueOf(((ExtensionElement)canCompleteList.get(0)).getElementText()));
                }
                if (StringUtils.isNotEmpty((CharSequence)humanTask.getAssignee())) {
                    ObjectNode assigneeNode = this.objectMapper.createObjectNode();
                    assigneeNode.put("id", humanTask.getAssignee());
                    idmNode.set("assignee", (JsonNode)assigneeNode);
                    idmNode.put("type", "user");
                    this.fillProperty("email", "assignee-info-email", assigneeNode, humanTask);
                    this.fillProperty("firstName", "assignee-info-firstname", assigneeNode, humanTask);
                    this.fillProperty("lastName", "assignee-info-lastname", assigneeNode, humanTask);
                }
                List idmCandidateUserList = (List)humanTask.getExtensionElements().get("flowable-idm-candidate-user");
                if (CollectionUtils.isNotEmpty(humanTask.getCandidateUsers()) && CollectionUtils.isNotEmpty(idmCandidateUserList)) {
                    ArrayList<String> candidateUserIds = new ArrayList<String>();
                    if (humanTask.getCandidateUsers().size() == 1) {
                        Object candidateUserArray;
                        idmNode.put("type", "users");
                        String candidateUsersString = (String)humanTask.getCandidateUsers().get(0);
                        for (String candidate : candidateUserArray = candidateUsersString.split(",")) {
                            candidateUserIds.add(candidate.trim());
                        }
                    } else {
                        candidateUserIds.addAll(humanTask.getCandidateUsers());
                    }
                    if (candidateUserIds.size() > 0) {
                        ArrayNode candidateUsersNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateUsers", (JsonNode)candidateUsersNode);
                        idmNode.put("type", "users");
                        for (String candidateUser : humanTask.getCandidateUsers()) {
                            ObjectNode candidateUserNode = this.objectMapper.createObjectNode();
                            candidateUserNode.put("id", candidateUser);
                            candidateUsersNode.add((JsonNode)candidateUserNode);
                            this.fillProperty("email", "user-info-email-" + candidateUser, candidateUserNode, humanTask);
                            this.fillProperty("firstName", "user-info-firstname-" + candidateUser, candidateUserNode, humanTask);
                            this.fillProperty("lastName", "user-info-lastname-" + candidateUser, candidateUserNode, humanTask);
                        }
                    }
                }
                List idmCandidateGroupList = (List)humanTask.getExtensionElements().get("flowable-idm-candidate-group");
                if (CollectionUtils.isNotEmpty(humanTask.getCandidateGroups()) && CollectionUtils.isNotEmpty(idmCandidateGroupList)) {
                    ArrayList<String> candidateGroupIds = new ArrayList<String>();
                    if (humanTask.getCandidateGroups().size() == 1) {
                        String[] candidateGroupArray;
                        idmNode.put("type", "groups");
                        String candidateGroupsString = (String)humanTask.getCandidateGroups().get(0);
                        for (String candidate : candidateGroupArray = candidateGroupsString.split(",")) {
                            candidateGroupIds.add(candidate.trim());
                        }
                    } else {
                        candidateGroupIds.addAll(humanTask.getCandidateGroups());
                    }
                    if (candidateGroupIds.size() > 0) {
                        ArrayNode candidateGroupsNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateGroups", (JsonNode)candidateGroupsNode);
                        idmNode.put("type", "groups");
                        for (String candidateGroup : humanTask.getCandidateGroups()) {
                            ObjectNode candidateGroupNode = this.objectMapper.createObjectNode();
                            candidateGroupNode.put("id", candidateGroup);
                            candidateGroupsNode.add((JsonNode)candidateGroupNode);
                            this.fillProperty("name", "group-info-name-" + candidateGroup, candidateGroupNode, humanTask);
                        }
                    }
                }
            } else {
                ObjectNode candidateNode;
                ArrayNode candidateArrayNode;
                assignmentValuesNode.put("type", "static");
                if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                    assignmentValuesNode.put("assignee", assignee);
                }
                if (CollectionUtils.isNotEmpty(humanTask.getCandidateUsers())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateUser : humanTask.getCandidateUsers()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateUser);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateUsers", (JsonNode)candidateArrayNode);
                }
                if (CollectionUtils.isNotEmpty(humanTask.getCandidateGroups())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateGroup : humanTask.getCandidateGroups()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateGroup);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateGroups", (JsonNode)candidateArrayNode);
                }
            }
            assignmentNode.set("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.set("usertaskassignment", (JsonNode)assignmentNode);
        }
    }

    protected void convertTaskListenersToJson(ObjectNode propertiesNode, HumanTask humanTask) {
        ObjectNode taskListenersNode = ListenerConverterUtil.convertListenersToJson(this.objectMapper, "taskListeners", humanTask.getTaskListeners());
        if (taskListenersNode != null) {
            propertiesNode.set("tasklisteners", (JsonNode)taskListenersNode);
        }
    }

    protected int getExtensionElementValueAsInt(String name, HumanTask humanTask) {
        int intValue = 0;
        String value = this.getExtensionElementValue(name, humanTask);
        if (NumberUtils.isCreatable((String)value)) {
            intValue = Integer.valueOf(value);
        }
        return intValue;
    }

    protected String getExtensionElementValue(String name, HumanTask humanTask) {
        String value = "";
        if (CollectionUtils.isNotEmpty((Collection)humanTask.getExtensionElements().get(name))) {
            ExtensionElement extensionElement = (ExtensionElement)((List)humanTask.getExtensionElements().get(name)).get(0);
            value = extensionElement.getElementText();
        }
        return value;
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode assignmentDefNode;
        HumanTask task = new HumanTask();
        task.setPriority(CmmnJsonConverterUtil.getPropertyValueAsString("prioritydefinition", elementNode));
        task.setFormKey(CmmnJsonConverterUtil.getPropertyFormKey(elementNode, converterContext));
        task.setValidateFormFields(CmmnJsonConverterUtil.getPropertyValueAsString("formfieldvalidation", elementNode));
        task.setDueDate(CmmnJsonConverterUtil.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setCategory(CmmnJsonConverterUtil.getPropertyValueAsString("categorydefinition", elementNode));
        task.setTaskIdVariableName(CmmnJsonConverterUtil.getPropertyValueAsString("taskidvariablename", elementNode));
        this.convertJsonToTaskListeners(elementNode, task);
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        JsonNode assignmentNode = CmmnJsonConverterUtil.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (assignmentDefNode = assignmentNode.get("assignment")) != null) {
            JsonNode idmDefNode;
            JsonNode typeNode = assignmentDefNode.get("type");
            JsonNode canCompleteTaskNode = assignmentDefNode.get("initiatorCanCompleteTask");
            if (typeNode == null || "static".equalsIgnoreCase(typeNode.asText())) {
                JsonNode assigneeNode = assignmentDefNode.get("assignee");
                if (assigneeNode != null && !assigneeNode.isNull()) {
                    task.setAssignee(assigneeNode.asText());
                }
                task.setCandidateUsers(this.getValueAsList("candidateUsers", assignmentDefNode));
                task.setCandidateGroups(this.getValueAsList("candidateGroups", assignmentDefNode));
                if (StringUtils.isNotEmpty((CharSequence)task.getAssignee())) {
                    if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                        this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
                    } else {
                        this.addInitiatorCanCompleteExtensionElement(false, task);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)task.getAssignee())) {
                    this.addInitiatorCanCompleteExtensionElement(true, task);
                }
            } else if ("idm".equalsIgnoreCase(typeNode.asText()) && (idmDefNode = assignmentDefNode.get("idm")) != null && idmDefNode.has("type")) {
                JsonNode idmTypeNode = idmDefNode.get("type");
                if (idmTypeNode != null && "user".equalsIgnoreCase(idmTypeNode.asText()) && idmDefNode.has("assignee")) {
                    this.fillAssigneeInfo(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "users".equalsIgnoreCase(idmTypeNode.asText()) && idmDefNode.has("candidateUsers")) {
                    this.fillCandidateUsers(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "groups".equalsIgnoreCase(idmTypeNode.asText()) && idmDefNode.has("candidateGroups")) {
                    this.fillCandidateGroups(idmDefNode, canCompleteTaskNode, task);
                } else {
                    task.setAssignee("${" + cmmnModel.getPrimaryCase().getInitiatorVariableName() + "}");
                    this.addExtensionElement("flowable-idm-initiator", String.valueOf(true), task);
                }
            }
        }
        return task;
    }

    protected void convertJsonToTaskListeners(JsonNode elementNode, HumanTask task) {
        List<FlowableListener> listeners = ListenerConverterUtil.convertJsonToListeners(elementNode, "tasklisteners", "taskListeners");
        if (listeners != null && !listeners.isEmpty()) {
            task.setTaskListeners(listeners);
        }
    }

    protected void fillAssigneeInfo(JsonNode idmDefNode, JsonNode canCompleteTaskNode, HumanTask task) {
        JsonNode assigneeNode = idmDefNode.get("assignee");
        if (assigneeNode != null && !assigneeNode.isNull()) {
            JsonNode idNode = assigneeNode.get("id");
            JsonNode emailNode = assigneeNode.get("email");
            if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                task.setAssignee(idNode.asText());
                this.addExtensionElement("flowable-idm-assignee", String.valueOf(true), task);
                this.addExtensionElement("assignee-info-email", emailNode, task);
                this.addExtensionElement("assignee-info-firstname", assigneeNode.get("firstName"), task);
                this.addExtensionElement("assignee-info-lastname", assigneeNode.get("lastName"), task);
            }
        }
        if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
            this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
        } else {
            this.addInitiatorCanCompleteExtensionElement(false, task);
        }
    }

    protected void fillCandidateUsers(JsonNode idmDefNode, JsonNode canCompleteTaskNode, HumanTask task) {
        ArrayList<String> candidateUsers = new ArrayList<String>();
        JsonNode candidateUsersNode = idmDefNode.get("candidateUsers");
        if (candidateUsersNode != null && candidateUsersNode.isArray()) {
            ArrayList<String> emails = new ArrayList<String>();
            for (JsonNode userNode : candidateUsersNode) {
                if (userNode == null || userNode.isNull()) continue;
                JsonNode idNode = userNode.get("id");
                JsonNode emailNode = userNode.get("email");
                if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                    String id = idNode.asText();
                    candidateUsers.add(id);
                    this.addExtensionElement("user-info-email-" + id, emailNode, task);
                    this.addExtensionElement("user-info-firstname-" + id, userNode.get("firstName"), task);
                    this.addExtensionElement("user-info-lastname-" + id, userNode.get("lastName"), task);
                    continue;
                }
                if (emailNode == null || emailNode.isNull() || !StringUtils.isNotEmpty((CharSequence)emailNode.asText())) continue;
                String email = emailNode.asText();
                candidateUsers.add(email);
                emails.add(email);
            }
            if (emails.size() > 0) {
                this.addExtensionElement("flowable-candidate-users-emails", StringUtils.join(emails, (String)","), task);
            }
            if (candidateUsers.size() > 0) {
                this.addExtensionElement("flowable-idm-candidate-user", String.valueOf(true), task);
                if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                    this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
                } else {
                    this.addInitiatorCanCompleteExtensionElement(false, task);
                }
            }
        }
        if (candidateUsers.size() > 0) {
            task.setCandidateUsers(candidateUsers);
        }
    }

    protected void fillCandidateGroups(JsonNode idmDefNode, JsonNode canCompleteTaskNode, HumanTask task) {
        ArrayList<String> candidateGroups = new ArrayList<String>();
        JsonNode candidateGroupsNode = idmDefNode.get("candidateGroups");
        if (candidateGroupsNode != null && candidateGroupsNode.isArray()) {
            for (JsonNode groupNode : candidateGroupsNode) {
                if (groupNode == null || groupNode.isNull()) continue;
                JsonNode idNode = groupNode.get("id");
                JsonNode nameNode = groupNode.get("name");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                String id = idNode.asText();
                candidateGroups.add(id);
                this.addExtensionElement("group-info-name-" + id, nameNode, task);
            }
        }
        if (candidateGroups.size() > 0) {
            task.setCandidateGroups(candidateGroups);
            this.addExtensionElement("flowable-idm-candidate-group", String.valueOf(true), task);
            if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
            } else {
                this.addInitiatorCanCompleteExtensionElement(false, task);
            }
        }
    }

    protected void addInitiatorCanCompleteExtensionElement(boolean canCompleteTask, HumanTask task) {
        this.addExtensionElement("initiator-can-complete", String.valueOf(canCompleteTask), task);
    }

    protected void addExtensionElement(String name, JsonNode elementNode, HumanTask task) {
        if (elementNode != null && !elementNode.isNull() && StringUtils.isNotEmpty((CharSequence)elementNode.asText())) {
            this.addExtensionElement(name, elementNode.asText(), task);
        }
    }

    protected void addExtensionElement(String name, String elementText, HumanTask task) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://flowable.org/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(elementText);
        task.addExtensionElement(extensionElement);
    }

    protected void fillProperty(String propertyName, String extensionElementName, ObjectNode elementNode, HumanTask task) {
        List extensionElementList = (List)task.getExtensionElements().get(extensionElementName);
        if (CollectionUtils.isNotEmpty(extensionElementList)) {
            elementNode.put(propertyName, ((ExtensionElement)extensionElementList.get(0)).getElementText());
        }
    }
}

