/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.DecisionTableKeyAwareConverter;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.editor.json.model.CmmnModelInfo;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public class DecisionTaskJsonConverter
extends BaseCmmnJsonConverter
implements DecisionTableKeyAwareConverter {
    protected Map<String, CmmnModelInfo> decisionTableKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        DecisionTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        DecisionTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("DecisionTask", DecisionTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(DecisionTask.class, DecisionTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "DecisionTask";
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        String decisionTableKey;
        DecisionTask decisionTask = new DecisionTask();
        JsonNode decisionTableReferenceNode = CmmnJsonConverterUtil.getProperty("decisiontaskdecisiontablereference", elementNode);
        if (decisionTableReferenceNode != null && decisionTableReferenceNode.has("id") && !decisionTableReferenceNode.get("id").isNull() && StringUtils.isNotEmpty((CharSequence)(decisionTableKey = decisionTableReferenceNode.get("key").asText()))) {
            decisionTask.setDecisionRef(decisionTableKey);
        }
        this.addBooleanField(elementNode, decisionTask, "decisiontaskthrowerroronnohits", "decisionTaskThrowErrorOnNoHits");
        this.addBooleanField(elementNode, decisionTask, "decisiontaskfallbacktodefaulttenant", "fallbackToDefaultTenant");
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)decisionTask);
        return decisionTask;
    }

    protected void addBooleanField(JsonNode elementNode, DecisionTask decisionTask, String propertyName, String fieldName) {
        boolean decisionTableThrowErrorOnNoHitsNode = CmmnJsonConverterUtil.getPropertyValueAsBoolean(propertyName, elementNode);
        FieldExtension decisionTableThrowErrorOnNoHitsField = new FieldExtension();
        decisionTableThrowErrorOnNoHitsField.setFieldName(fieldName);
        decisionTableThrowErrorOnNoHitsField.setStringValue(decisionTableThrowErrorOnNoHitsNode ? "true" : "false");
        decisionTask.getFieldExtensions().add(decisionTableThrowErrorOnNoHitsField);
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        CmmnModelInfo modelInfo;
        DecisionTask decisionTask = (DecisionTask)((PlanItem)baseElement).getPlanItemDefinition();
        ObjectNode decisionReferenceNode = this.objectMapper.createObjectNode();
        propertiesNode.set("decisiontaskdecisiontablereference", (JsonNode)decisionReferenceNode);
        CmmnModelInfo cmmnModelInfo = modelInfo = this.decisionTableKeyMap != null && decisionTask.getDecisionRef() != null ? this.decisionTableKeyMap.get(decisionTask.getDecisionRef()) : null;
        if (modelInfo != null) {
            decisionReferenceNode.put("id", modelInfo.getId());
            decisionReferenceNode.put("name", modelInfo.getName());
            decisionReferenceNode.put("key", modelInfo.getKey());
        }
        for (FieldExtension fieldExtension : decisionTask.getFieldExtensions()) {
            if ("decisionTaskThrowErrorOnNoHits".equals(fieldExtension.getFieldName())) {
                propertiesNode.put("decisiontaskthrowerroronnohits", Boolean.parseBoolean(fieldExtension.getStringValue()));
            }
            if (!"fallbackToDefaultTenant".equals(fieldExtension.getFieldName())) continue;
            propertiesNode.put("decisiontaskfallbacktodefaulttenant", Boolean.parseBoolean(fieldExtension.getStringValue()));
        }
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)decisionTask);
    }

    @Override
    public void setDecisionTableKeyMap(Map<String, CmmnModelInfo> decisionTableMap) {
        this.decisionTableKeyMap = decisionTableMap;
    }
}

