/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.CmmnConfigurationResource;
import org.flowable.cmmn.engine.test.CmmnDeployment;
import org.flowable.cmmn.engine.test.CmmnDeploymentId;
import org.flowable.cmmn.engine.test.FlowableCmmnTestHelper;
import org.flowable.cmmn.engine.test.impl.CmmnTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableCmmnExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.cmmn.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableCmmnExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(CmmnEngineConfiguration.class, CmmnEngine.class, CmmnRepositoryService.class, CmmnRuntimeService.class, CmmnTaskService.class, CmmnHistoryService.class, CmmnManagementService.class));
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        FlowableCmmnTestHelper flowableTestHelper = this.getTestHelper(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CmmnDeployment.class).ifPresent(deployment -> {
            String deploymentIdFromDeploymentAnnotation = CmmnTestHelper.annotationDeploymentSetUp(flowableTestHelper.getCmmnEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
        });
    }

    public void afterEach(ExtensionContext context) {
        FlowableCmmnTestHelper flowableTestHelper = this.getTestHelper(context);
        CmmnEngine cmmnEngine = flowableTestHelper.getCmmnEngine();
        String deploymentIdFromDeploymentAnnotation = flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentIdFromDeploymentAnnotation != null) {
            CmmnTestHelper.annotationDeploymentTearDown(cmmnEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        cmmnEngine.getCmmnEngineConfiguration().getClock().reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType) || FlowableCmmnTestHelper.class.equals(parameterType) || parameterContext.isAnnotated(CmmnDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        CmmnEngine cmmnEngine;
        FlowableCmmnTestHelper flowableTestHelper = this.getTestHelper(context);
        if (parameterContext.isAnnotated(CmmnDeploymentId.class)) {
            return flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(cmmnEngine = flowableTestHelper.getCmmnEngine())) {
            return cmmnEngine;
        }
        if (FlowableCmmnTestHelper.class.equals(parameterType)) {
            return flowableTestHelper;
        }
        try {
            return CmmnEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)cmmnEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + parameterType, (Throwable)ex);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), CmmnConfigurationResource.class).map(CmmnConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableCmmnTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableCmmnTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableCmmnTestHelper(this.createCmmnEngine(context)), FlowableCmmnTestHelper.class);
    }

    protected CmmnEngine createCmmnEngine(ExtensionContext context) {
        return CmmnTestHelper.getCmmnEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

