/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.flowable.cmmn.api.migration.ActivatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.migration.MoveToAvailablePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.RemoveWaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.TerminatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.WaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentBuilderImpl;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentConstants;
import org.flowable.common.engine.api.FlowableException;

public class CaseInstanceMigrationDocumentConverter
implements CaseInstanceMigrationDocumentConstants {
    protected static Predicate<JsonNode> isNotNullNode = jsonNode -> jsonNode != null && !jsonNode.isNull();
    protected static Predicate<JsonNode> isSingleTextValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isTextual();
    protected static Predicate<JsonNode> isMultiValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isArray();
    protected static ObjectMapper objectMapper = new ObjectMapper();

    public static JsonNode convertToJson(CaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        JsonNode caseInstanceVariablesNode;
        ArrayNode removeWaitingForRepetitionMappingNodes;
        ArrayNode waitingForRepetitionMappingNodes;
        ArrayNode moveToAvailableMappingNodes;
        ArrayNode terminateMappingNodes;
        ArrayNode activateMappingNodes;
        ObjectNode documentNode = objectMapper.createObjectNode();
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionId() != null) {
            documentNode.put("toCaseDefinitionId", caseInstanceMigrationDocument.getMigrateToCaseDefinitionId());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey() != null) {
            documentNode.put("toCaseDefinitionKey", caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion() != null) {
            documentNode.put("toCaseDefinitionVersion", caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId() != null) {
            documentNode.put("toCaseDefinitionTenantId", caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId());
        }
        if ((activateMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonActivatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getActivatePlanItemDefinitionMappings())) != null && !activateMappingNodes.isNull()) {
            documentNode.set("activatePlanItemDefinitions", (JsonNode)activateMappingNodes);
        }
        if ((terminateMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonTerminatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getTerminatePlanItemDefinitionMappings())) != null && !terminateMappingNodes.isNull()) {
            documentNode.set("terminatePlanItemDefinitions", (JsonNode)terminateMappingNodes);
        }
        if ((moveToAvailableMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonMoveToAvailablePlanItemDefinitionMappings(caseInstanceMigrationDocument.getMoveToAvailablePlanItemDefinitionMappings())) != null && !moveToAvailableMappingNodes.isNull()) {
            documentNode.set("moveToAvailablePlanItemDefinitions", (JsonNode)moveToAvailableMappingNodes);
        }
        if ((waitingForRepetitionMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getWaitingForRepetitionPlanItemDefinitionMappings())) != null && !waitingForRepetitionMappingNodes.isNull()) {
            documentNode.set("waitingForRepetitionPlanItemDefinitions", (JsonNode)waitingForRepetitionMappingNodes);
        }
        if ((removeWaitingForRepetitionMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonRemoveWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getRemoveWaitingForRepetitionPlanItemDefinitionMappings())) != null && !removeWaitingForRepetitionMappingNodes.isNull()) {
            documentNode.set("removeWaitingForRepetitionPlanItemDefinitions", (JsonNode)removeWaitingForRepetitionMappingNodes);
        }
        if ((caseInstanceVariablesNode = CaseInstanceMigrationDocumentConverter.convertToJsonCaseInstanceVariables(caseInstanceMigrationDocument, objectMapper)) != null && !caseInstanceVariablesNode.isNull()) {
            documentNode.set("caseInstanceVariables", caseInstanceVariablesNode);
        }
        return documentNode;
    }

    public static String convertToJsonString(CaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        JsonNode jsonNode = CaseInstanceMigrationDocumentConverter.convertToJson(caseInstanceMigrationDocument);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        try {
            return objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            return jsonNode.toString();
        }
    }

    protected static ArrayNode convertToJsonActivatePlanItemDefinitionMappings(List<ActivatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ActivatePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("newAssignee", mapping.getNewAssignee());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonTerminatePlanItemDefinitionMappings(List<TerminatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (TerminatePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonMoveToAvailablePlanItemDefinitionMappings(List<MoveToAvailablePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (MoveToAvailablePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonWaitingForRepetitionPlanItemDefinitionMappings(List<WaitingForRepetitionPlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (WaitingForRepetitionPlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonRemoveWaitingForRepetitionPlanItemDefinitionMappings(List<RemoveWaitingForRepetitionPlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (RemoveWaitingForRepetitionPlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    public static CaseInstanceMigrationDocument convertFromJson(String jsonCaseInstanceMigrationDocument) {
        try {
            JsonNode caseInstanceVariablesNode;
            JsonNode removeWaitingForRepetitionMappingNodes;
            JsonNode waitingForRepetitionMappingNodes;
            JsonNode moveToAvailableMappingNodes;
            JsonNode terminateMappingNodes;
            JsonNode rootNode = objectMapper.readTree(jsonCaseInstanceMigrationDocument);
            CaseInstanceMigrationDocumentBuilderImpl documentBuilder = new CaseInstanceMigrationDocumentBuilderImpl();
            documentBuilder.setCaseDefinitionToMigrateTo(CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionId", rootNode));
            String caseDefinitionKey = CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionKey", rootNode);
            Integer caseDefinitionVersion = CaseInstanceMigrationDocumentConverter.getJsonPropertyAsInteger("toCaseDefinitionVersion", rootNode);
            documentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
            documentBuilder.setTenantId(CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionTenantId", rootNode));
            JsonNode activateMappingNodes = rootNode.get("activatePlanItemDefinitions");
            if (activateMappingNodes != null) {
                for (Iterator mappingNode : activateMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    ActivatePlanItemDefinitionMapping activateDefinitionMapping = new ActivatePlanItemDefinitionMapping(planItemDefinitionId);
                    String newAssginee = CaseInstanceMigrationDocumentConverter.getJsonProperty("newAssignee", (JsonNode)mappingNode);
                    activateDefinitionMapping.setNewAssignee(newAssginee);
                    documentBuilder.addActivatePlanItemDefinitionMapping(activateDefinitionMapping);
                }
            }
            if ((terminateMappingNodes = rootNode.get("terminatePlanItemDefinitions")) != null) {
                for (Iterator mappingNode : terminateMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    TerminatePlanItemDefinitionMapping terminateDefinitionMapping = new TerminatePlanItemDefinitionMapping(planItemDefinitionId);
                    documentBuilder.addTerminatePlanItemDefinitionMapping(terminateDefinitionMapping);
                }
            }
            if ((moveToAvailableMappingNodes = rootNode.get("moveToAvailablePlanItemDefinitions")) != null) {
                for (Iterator mappingNode : moveToAvailableMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    MoveToAvailablePlanItemDefinitionMapping moveToAvailableDefinitionMapping = new MoveToAvailablePlanItemDefinitionMapping(planItemDefinitionId);
                    documentBuilder.addMoveToAvailablePlanItemDefinitionMapping(moveToAvailableDefinitionMapping);
                }
            }
            if ((waitingForRepetitionMappingNodes = rootNode.get("waitingForRepetitionPlanItemDefinitions")) != null) {
                for (Iterator mappingNode : waitingForRepetitionMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    WaitingForRepetitionPlanItemDefinitionMapping waitingForRepetitionDefinitionMapping = new WaitingForRepetitionPlanItemDefinitionMapping(planItemDefinitionId);
                    documentBuilder.addWaitingForRepetitionPlanItemDefinitionMapping(waitingForRepetitionDefinitionMapping);
                }
            }
            if ((removeWaitingForRepetitionMappingNodes = rootNode.get("removeWaitingForRepetitionPlanItemDefinitions")) != null) {
                for (JsonNode mappingNode : removeWaitingForRepetitionMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", mappingNode);
                    RemoveWaitingForRepetitionPlanItemDefinitionMapping removeWaitingForRepetitionDefinitionMapping = new RemoveWaitingForRepetitionPlanItemDefinitionMapping(planItemDefinitionId);
                    documentBuilder.addRemoveWaitingForRepetitionPlanItemDefinitionMapping(removeWaitingForRepetitionDefinitionMapping);
                }
            }
            if ((caseInstanceVariablesNode = rootNode.get("caseInstanceVariables")) != null) {
                Map caseInstanceVariables = (Map)CaseInstanceMigrationDocumentConverter.convertFromJsonNodeToObject(caseInstanceVariablesNode, objectMapper);
                documentBuilder.addCaseInstanceVariables(caseInstanceVariables);
            }
            return documentBuilder.build();
        }
        catch (IOException e) {
            throw new FlowableException("Error parsing Case Instance Migration Document", (Throwable)e);
        }
    }

    protected static JsonNode convertToJsonCaseInstanceVariables(CaseInstanceMigrationDocument caseInstanceMigrationDocument, ObjectMapper objectMapper) {
        Map caseInstanceVariables = caseInstanceMigrationDocument.getCaseInstanceVariables();
        if (caseInstanceVariables != null && !caseInstanceVariables.isEmpty()) {
            return objectMapper.valueToTree((Object)caseInstanceVariables);
        }
        return null;
    }

    protected static <T> T convertFromJsonNodeToObject(JsonNode jsonNode, ObjectMapper objectMapper) {
        return (T)objectMapper.convertValue((Object)jsonNode, new TypeReference<T>(){});
    }

    protected static String getJsonProperty(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asText();
        }
        return null;
    }

    protected static Integer getJsonPropertyAsInteger(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asInt();
        }
        return null;
    }
}

