/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.reactivation.CaseReactivationBuilderImpl;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ReactivateHistoricCaseInstanceCmd
implements Command<CaseInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final CaseReactivationBuilderImpl reactivationBuilder;

    public ReactivateHistoricCaseInstanceCmd(CaseReactivationBuilderImpl reactivationBuilder) {
        this.reactivationBuilder = reactivationBuilder;
    }

    public CaseInstance execute(CommandContext commandContext) {
        Object listenerAvailable;
        ReactivateEventListener reactivateEventListener;
        String availableConditionExpression;
        if (this.reactivationBuilder.getCaseInstanceId() == null) {
            throw new FlowableIllegalArgumentException("No historic case instance id provided");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        HistoricCaseInstance instance = (HistoricCaseInstance)cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager().createHistoricCaseInstanceQuery().caseInstanceId(this.reactivationBuilder.getCaseInstanceId()).singleResult();
        if (instance == null) {
            throw new FlowableObjectNotFoundException("No historic case instance to be reactivated found with id: " + this.reactivationBuilder.getCaseInstanceId(), HistoricCaseInstance.class);
        }
        if (instance.getEndTime() == null) {
            throw new FlowableIllegalStateException("Case instance is still running, cannot reactivate historic case instance: " + this.reactivationBuilder.getCaseInstanceId());
        }
        CaseInstanceEntity caseInstanceEntity = cmmnEngineConfiguration.getCaseInstanceHelper().copyHistoricCaseInstanceToRuntime(instance);
        caseInstanceEntity.setState("active");
        caseInstanceEntity.setLastReactivationTime(cmmnEngineConfiguration.getClock().getCurrentTime());
        caseInstanceEntity.setLastReactivationUserId(Authentication.getAuthenticatedUserId());
        if (this.reactivationBuilder.hasVariables()) {
            caseInstanceEntity.setVariables(this.reactivationBuilder.getVariables());
        }
        if (this.reactivationBuilder.hasTransientVariables()) {
            caseInstanceEntity.setTransientVariables(this.reactivationBuilder.getTransientVariables());
        }
        if (StringUtils.isNotEmpty((CharSequence)(availableConditionExpression = (reactivateEventListener = CaseDefinitionUtil.getCase(instance.getCaseDefinitionId()).getReactivateEventListener()).getReactivationAvailableConditionExpression())) && !Boolean.TRUE.equals(listenerAvailable = CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager().createExpression(availableConditionExpression).getValue((VariableContainer)caseInstanceEntity))) {
            throw new FlowableIllegalStateException("The case instance " + caseInstanceEntity.getId() + " cannot be reactivated, as the available condition of its reactivate event listener did not evaluate to true.");
        }
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleReactivateCaseInstance(caseInstanceEntity);
        }
        cmmnEngineConfiguration.getCmmnHistoryManager().recordHistoricCaseInstanceReactivated(caseInstanceEntity);
        CommandContextUtil.getAgenda(commandContext).planReactivateCaseInstanceOperation(caseInstanceEntity);
        return caseInstanceEntity;
    }
}

