/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemFutureJavaDelegate;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.ExceptionUtil;

public class PlanItemFutureJavaDelegateActivityBehavior
extends CoreCmmnActivityBehavior {
    protected PlanItemFutureJavaDelegate<Object> planItemJavaDelegate;

    public PlanItemFutureJavaDelegateActivityBehavior(PlanItemFutureJavaDelegate<?> planItemJavaDelegate) {
        this.planItemJavaDelegate = planItemJavaDelegate;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
            CmmnLoggingSessionUtil.addLoggingData("serviceTaskEnter", "Executing service task with java class " + this.planItemJavaDelegate.getClass().getName(), planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
        }
        CompletableFuture future = this.planItemJavaDelegate.execute((DelegatePlanItemInstance)planItemInstanceEntity, cmmnEngineConfiguration.getAsyncTaskInvoker());
        CommandContextUtil.getAgenda(commandContext).planFutureOperation(future, new DelegateCompleteAction(planItemInstanceEntity, cmmnEngineConfiguration.isLoggingSessionEnabled()));
    }

    protected class DelegateCompleteAction
    implements BiConsumer<Object, Throwable> {
        protected final PlanItemInstanceEntity planItemInstance;
        protected final boolean loggingSessionEnabled;

        public DelegateCompleteAction(PlanItemInstanceEntity planItemInstance, boolean loggingSessionEnabled) {
            this.planItemInstance = planItemInstance;
            this.loggingSessionEnabled = loggingSessionEnabled;
        }

        @Override
        public void accept(Object value, Throwable throwable) {
            if (throwable == null) {
                PlanItemFutureJavaDelegateActivityBehavior.this.planItemJavaDelegate.afterExecution((DelegatePlanItemInstance)this.planItemInstance, value);
                if (this.loggingSessionEnabled) {
                    CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
                    CmmnLoggingSessionUtil.addLoggingData("serviceTaskExit", "Executed service task with java class " + PlanItemFutureJavaDelegateActivityBehavior.this.planItemJavaDelegate.getClass().getName(), this.planItemInstance, cmmnEngineConfiguration.getObjectMapper());
                }
                CommandContextUtil.getAgenda().planCompletePlanItemInstanceOperation(this.planItemInstance);
            } else {
                ExceptionUtil.sneakyThrow((Throwable)throwable);
            }
        }
    }
}

