/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.List;
import org.flowable.cmmn.engine.impl.cfg.DelegateExpressionFieldInjectionMode;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.ReflectUtil;

public class DelegateExpressionUtil {
    public static Object resolveDelegateExpression(Expression expression, VariableContainer variableContainer, List<FieldExtension> fieldExtensions) {
        Object delegate = expression.getValue(variableContainer);
        if (fieldExtensions != null && fieldExtensions.size() > 0) {
            DelegateExpressionFieldInjectionMode injectionMode = CommandContextUtil.getCmmnEngineConfiguration().getDelegateExpressionFieldInjectionMode();
            if (injectionMode == DelegateExpressionFieldInjectionMode.COMPATIBILITY) {
                DelegateExpressionUtil.applyFieldExtensions(fieldExtensions, delegate, variableContainer, true);
            } else if (injectionMode == DelegateExpressionFieldInjectionMode.MIXED) {
                DelegateExpressionUtil.applyFieldExtensions(fieldExtensions, delegate, variableContainer, false);
            }
        }
        return delegate;
    }

    protected static void applyFieldExtensions(List<FieldExtension> fieldExtensions, Object target, VariableContainer variableContainer, boolean throwExceptionOnMissingField) {
        if (fieldExtensions != null) {
            for (FieldExtension fieldExtension : fieldExtensions) {
                DelegateExpressionUtil.applyFieldExtension(fieldExtension, target, throwExceptionOnMissingField);
            }
        }
    }

    protected static void applyFieldExtension(FieldExtension fieldExtension, Object target, boolean throwExceptionOnMissingField) {
        String value = null;
        if (fieldExtension.getStringValue() != null) {
            value = fieldExtension.getStringValue();
        } else if (fieldExtension.getExpression() != null) {
            ExpressionManager expressionManager = CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager();
            value = expressionManager.createExpression(fieldExtension.getExpression());
        }
        ReflectUtil.invokeSetterOrField((Object)target, (String)fieldExtension.getFieldName(), (Object)value, (boolean)throwExceptionOnMissingField);
    }
}

