/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntityManager;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntityManager;

public class CaseInstanceEntityManagerImpl
extends AbstractEngineEntityManager<CmmnEngineConfiguration, CaseInstanceEntity, CaseInstanceDataManager>
implements CaseInstanceEntityManager {
    public CaseInstanceEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseInstanceDataManager caseInstanceDataManager) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration, (DataManager)caseInstanceDataManager);
    }

    @Override
    public CaseInstanceQuery createCaseInstanceQuery() {
        return new CaseInstanceQueryImpl(((CmmnEngineConfiguration)this.engineConfiguration).getCommandExecutor());
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return ((CaseInstanceDataManager)this.dataManager).findCaseInstancesByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQuery query) {
        return ((CaseInstanceDataManager)this.dataManager).findByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public List<CaseInstance> findWithVariablesByCriteria(CaseInstanceQuery query) {
        return ((CaseInstanceDataManager)this.dataManager).findWithVariablesByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public long countByCriteria(CaseInstanceQuery query) {
        return ((CaseInstanceDataManager)this.dataManager).countByCriteria((CaseInstanceQueryImpl)query);
    }

    @Override
    public void delete(String caseInstanceId, boolean cascade, String deleteReason) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)((CaseInstanceDataManager)this.dataManager).findById(caseInstanceId);
        this.getVariableInstanceEntityManager().deleteByScopeIdAndScopeType(caseInstanceId, "cmmn");
        this.getIdentityLinkEntityManager().deleteIdentityLinksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        if (((CmmnEngineConfiguration)this.engineConfiguration).isEnableEntityLinks()) {
            this.getEntityLinkEntityManager().deleteEntityLinksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        }
        TaskEntityManager taskEntityManager = this.getTaskEntityManager();
        List taskEntities = taskEntityManager.findTasksByScopeIdAndScopeType(caseInstanceId, "cmmn");
        for (TaskEntity taskEntity : taskEntities) {
            TaskHelper.deleteTask(taskEntity, deleteReason, cascade, true);
        }
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
        eventSubscriptionService.deleteEventSubscriptionsForScopeIdAndType(caseInstanceId, "cmmn");
        this.getSentryPartInstanceEntityManager().deleteByCaseInstanceId(caseInstanceId);
        this.getMilestoneInstanceEntityManager().deleteByCaseInstanceId(caseInstanceId);
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.getPlanItemInstanceEntityManager();
        ArrayList<PlanItemInstanceEntity> stagePlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        ArrayList<PlanItemInstanceEntity> childTaskPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        this.collectPlanItemInstances(caseInstanceEntity, stagePlanItemInstances, childTaskPlanItemInstances);
        this.getIdentityLinkEntityManager().deleteIdentityLinksByScopeIdAndScopeType(caseInstanceId, "planItem");
        for (int i = stagePlanItemInstances.size() - 1; i >= 0; --i) {
            planItemInstanceEntityManager.deleteByStageInstanceId(((PlanItemInstanceEntity)stagePlanItemInstances.get(i)).getId());
        }
        planItemInstanceEntityManager.deleteByCaseInstanceId(caseInstanceId);
        for (PlanItemInstanceEntity childTaskPlanItemInstance : childTaskPlanItemInstances) {
            if (!"active".equals(childTaskPlanItemInstance.getState())) continue;
            ChildTaskActivityBehavior childTaskActivityBehavior = (ChildTaskActivityBehavior)childTaskPlanItemInstance.getPlanItem().getBehavior();
            childTaskActivityBehavior.deleteChildEntity(CommandContextUtil.getCommandContext(), childTaskPlanItemInstance, cascade);
        }
        JobEntityManager jobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getJobEntityManager();
        List jobs = jobEntityManager.findJobsByQueryCriteria(new JobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job job : jobs) {
            jobEntityManager.delete(job.getId());
        }
        TimerJobEntityManager timerJobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getTimerJobEntityManager();
        List timerJobs = timerJobEntityManager.findJobsByQueryCriteria(new TimerJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job timerJob : timerJobs) {
            timerJobEntityManager.delete(timerJob.getId());
        }
        SuspendedJobEntityManager suspendedJobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getSuspendedJobEntityManager();
        List suspendedJobs = suspendedJobEntityManager.findJobsByQueryCriteria(new SuspendedJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job suspendedJob : suspendedJobs) {
            suspendedJobEntityManager.delete(suspendedJob.getId());
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getDeadLetterJobEntityManager();
        List deadLetterJobs = deadLetterJobEntityManager.findJobsByQueryCriteria(new DeadLetterJobQueryImpl().scopeId(caseInstanceId).scopeType("cmmn"));
        for (Job deadLetterJob : deadLetterJobs) {
            deadLetterJobEntityManager.delete(deadLetterJob.getId());
        }
        this.delete(caseInstanceEntity);
    }

    protected void collectPlanItemInstances(PlanItemInstanceContainer planItemInstanceContainer, List<PlanItemInstanceEntity> stagePlanItemInstanceEntities, List<PlanItemInstanceEntity> childTaskPlanItemInstanceEntities) {
        for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceContainer.getChildPlanItemInstances()) {
            if (planItemInstanceEntity.isStage()) {
                stagePlanItemInstanceEntities.add(planItemInstanceEntity);
                this.collectPlanItemInstances(planItemInstanceEntity, stagePlanItemInstanceEntities, childTaskPlanItemInstanceEntities);
                continue;
            }
            if (planItemInstanceEntity.getPlanItem() == null || planItemInstanceEntity.getPlanItem().getBehavior() == null || !(planItemInstanceEntity.getPlanItem().getBehavior() instanceof ChildTaskActivityBehavior)) continue;
            childTaskPlanItemInstanceEntities.add(planItemInstanceEntity);
        }
    }

    @Override
    public void updateLockTime(String caseInstanceId) {
        Date expirationTime = this.getClock().getCurrentTime();
        int lockMillis = ((CmmnEngineConfiguration)this.engineConfiguration).getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        Date lockDate = lockCal.getTime();
        ((CaseInstanceDataManager)this.dataManager).updateLockTime(caseInstanceId, lockDate, expirationTime);
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        ((CaseInstanceDataManager)this.dataManager).clearLockTime(caseInstanceId);
    }

    @Override
    public void updateCaseInstanceBusinessKey(CaseInstanceEntity caseInstanceEntity, String businessKey) {
        if (businessKey != null) {
            caseInstanceEntity.setBusinessKey(businessKey);
            ((CmmnEngineConfiguration)this.engineConfiguration).getCmmnHistoryManager().recordUpdateBusinessKey(caseInstanceEntity, businessKey);
        }
    }

    protected VariableInstanceEntityManager getVariableInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getVariableServiceConfiguration().getVariableInstanceEntityManager();
    }

    protected IdentityLinkEntityManager getIdentityLinkEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
    }

    protected EntityLinkEntityManager getEntityLinkEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getEntityLinkServiceConfiguration().getEntityLinkEntityManager();
    }

    protected TaskEntityManager getTaskEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getTaskServiceConfiguration().getTaskEntityManager();
    }

    protected SentryPartInstanceEntityManager getSentryPartInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getSentryPartInstanceEntityManager();
    }

    protected MilestoneInstanceEntityManager getMilestoneInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getMilestoneInstanceEntityManager();
    }

    protected PlanItemInstanceEntityManager getPlanItemInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getPlanItemInstanceEntityManager();
    }
}

