/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.api.runtime.CaseInstanceState;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractEvaluationCriteriaOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateCriteriaOperation
extends AbstractEvaluationCriteriaOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateCriteriaOperation.class);

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId) {
        super(commandContext, caseInstanceEntityId, null, null);
    }

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        super(commandContext, caseInstanceEntityId, null, planItemLifeCycleEvent);
    }

    @Override
    public void run() {
        super.run();
        if (this.caseInstanceEntity.isDeleted()) {
            this.markAsNoop();
            return;
        }
        Criterion satisfiedExitCriterion = this.evaluateExitCriteria(this.caseInstanceEntity, (HasExitCriteria)this.getPlanModel(this.caseInstanceEntity));
        if (satisfiedExitCriterion != null) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminateCaseInstanceOperation(this.caseInstanceEntity.getId(), satisfiedExitCriterion.getId(), satisfiedExitCriterion.getExitType(), satisfiedExitCriterion.getExitEventType());
        } else {
            boolean criteriaChangeOrActiveChildren = this.evaluatePlanItemsCriteria(this.caseInstanceEntity);
            if (this.evaluateStagesAndCaseInstanceCompletion && this.evaluatePlanModelComplete() && !criteriaChangeOrActiveChildren && !CaseInstanceState.END_STATES.contains(this.caseInstanceEntity.getState())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No active plan items found for plan model, completing case instance");
                }
                CommandContextUtil.getAgenda(this.commandContext).planCompleteCaseInstanceOperation(this.caseInstanceEntity);
            } else {
                this.markAsNoop();
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Evaluate Criteria] case instance ");
        if (this.caseInstanceEntity != null) {
            stringBuilder.append(this.caseInstanceEntity.getId());
        } else {
            stringBuilder.append(this.caseInstanceEntityId);
        }
        if (this.planItemLifeCycleEvent != null) {
            stringBuilder.append(" with transition '").append(this.planItemLifeCycleEvent.getTransition()).append("' having fired");
            if (this.planItemLifeCycleEvent.getPlanItem() != null) {
                stringBuilder.append(" for ").append(this.planItemLifeCycleEvent.getPlanItem());
            }
        }
        return stringBuilder.toString();
    }
}

