/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.AbstractServiceTaskExport;
import org.flowable.cmmn.converter.export.CasePageTaskExport;
import org.flowable.cmmn.converter.export.CaseTaskExport;
import org.flowable.cmmn.converter.export.DecisionTaskExport;
import org.flowable.cmmn.converter.export.GenericEventListenerExport;
import org.flowable.cmmn.converter.export.HumanTaskExport;
import org.flowable.cmmn.converter.export.MilestoneExport;
import org.flowable.cmmn.converter.export.ProcessTaskExport;
import org.flowable.cmmn.converter.export.SignalEventListenerExport;
import org.flowable.cmmn.converter.export.StageExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.converter.export.TimerEventListenerExport;
import org.flowable.cmmn.converter.export.UserEventListenerExport;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.api.FlowableException;

public class PlanItemDefinitionExport
implements CmmnXmlConstants {
    protected static Map<String, AbstractPlanItemDefinitionExport> planItemDefinitionExporters = new HashMap<String, AbstractPlanItemDefinitionExport>();

    public static void addPlanItemDefinitionExport(AbstractPlanItemDefinitionExport exporter) {
        planItemDefinitionExporters.put(exporter.getExportablePlanItemDefinitionClass().getCanonicalName(), exporter);
    }

    public static void writePlanItemDefinition(CmmnModel model, PlanItemDefinition planItemDefinition, XMLStreamWriter xtw) throws Exception {
        AbstractPlanItemDefinitionExport exporter = PlanItemDefinitionExport.determineExporter(planItemDefinition);
        if (exporter == null) {
            throw new FlowableException("Cannot find a PlanItemDefinitionExporter for '" + planItemDefinition.getClass().getCanonicalName() + "'");
        }
        exporter.writePlanItemDefinition(model, planItemDefinition, xtw);
    }

    protected static AbstractPlanItemDefinitionExport determineExporter(PlanItemDefinition planItemDefinition) {
        AbstractPlanItemDefinitionExport exporter = null;
        Class<?> currentPlanItemDefinitionClass = planItemDefinition.getClass();
        while (exporter == null && !currentPlanItemDefinitionClass.equals(PlanItemDefinition.class)) {
            String exporterType = currentPlanItemDefinitionClass.getCanonicalName();
            exporter = planItemDefinitionExporters.get(exporterType);
            currentPlanItemDefinitionClass = currentPlanItemDefinitionClass.getSuperclass();
        }
        return exporter;
    }

    static {
        PlanItemDefinitionExport.addPlanItemDefinitionExport(StageExport.getInstance());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new TaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new HumanTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new CaseTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new DecisionTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new ProcessTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new AbstractServiceTaskExport.ServiceTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new AbstractServiceTaskExport.HttpServiceTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new AbstractServiceTaskExport.ScriptServiceTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new CasePageTaskExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new MilestoneExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new GenericEventListenerExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new SignalEventListenerExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new TimerEventListenerExport());
        PlanItemDefinitionExport.addPlanItemDefinitionExport(new UserEventListenerExport());
    }
}

