/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.CaseRefExpressionXmlConverter;
import org.flowable.cmmn.converter.CaseTaskXmlConverter;
import org.flowable.cmmn.converter.CaseXmlConverter;
import org.flowable.cmmn.converter.CmmnDiBoundsXmlConverter;
import org.flowable.cmmn.converter.CmmnDiEdgeXmlConverter;
import org.flowable.cmmn.converter.CmmnDiShapeXmlConverter;
import org.flowable.cmmn.converter.CmmnDiWaypointXmlConverter;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.ConditionXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.DecisionRefExpressionXmlConverter;
import org.flowable.cmmn.converter.DecisionTaskXmlConverter;
import org.flowable.cmmn.converter.DecisionXmlConverter;
import org.flowable.cmmn.converter.DefaultControlXmlConverter;
import org.flowable.cmmn.converter.DefinitionsXmlConverter;
import org.flowable.cmmn.converter.DocumentationXmlConverter;
import org.flowable.cmmn.converter.EntryCriterionXmlConverter;
import org.flowable.cmmn.converter.ExitCriterionXmlConverter;
import org.flowable.cmmn.converter.ExtensionElementsXMLConverter;
import org.flowable.cmmn.converter.GenericEventListenerXmlConverter;
import org.flowable.cmmn.converter.HumanTaskXmlConverter;
import org.flowable.cmmn.converter.IndentingXMLStreamWriter;
import org.flowable.cmmn.converter.ItemControlXmlConverter;
import org.flowable.cmmn.converter.ManualActivationRuleXmlConverter;
import org.flowable.cmmn.converter.MilestoneXmlConverter;
import org.flowable.cmmn.converter.PlanItemOnPartXmlConverter;
import org.flowable.cmmn.converter.PlanItemStartTriggerXmlConverter;
import org.flowable.cmmn.converter.PlanItemXmlConverter;
import org.flowable.cmmn.converter.PlanModelXmlConverter;
import org.flowable.cmmn.converter.ProcessRefExpressionXmlConverter;
import org.flowable.cmmn.converter.ProcessTaskXmlConverter;
import org.flowable.cmmn.converter.ProcessXmlConverter;
import org.flowable.cmmn.converter.RepetitionRuleXmlConverter;
import org.flowable.cmmn.converter.RequiredRuleXmlConverter;
import org.flowable.cmmn.converter.SentryIfPartXmlConverter;
import org.flowable.cmmn.converter.SentryXmlConverter;
import org.flowable.cmmn.converter.StageXmlConverter;
import org.flowable.cmmn.converter.StandardEventXmlConverter;
import org.flowable.cmmn.converter.TaskXmlConverter;
import org.flowable.cmmn.converter.TimerEventListenerXmlConverter;
import org.flowable.cmmn.converter.TimerExpressionXmlConverter;
import org.flowable.cmmn.converter.UserEventListenerXmlConverter;
import org.flowable.cmmn.converter.exception.XMLException;
import org.flowable.cmmn.converter.export.CaseExport;
import org.flowable.cmmn.converter.export.CmmnDIExport;
import org.flowable.cmmn.converter.export.DefinitionsRootExport;
import org.flowable.cmmn.converter.export.StageExport;
import org.flowable.cmmn.converter.util.PlanItemDependencyUtil;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.CmmnDiShape;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.Decision;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CmmnXmlConverter
implements CmmnXmlConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CmmnXmlConverter.class);
    protected static final String XSD_LOCATION = "org/flowable/impl/cmmn/parser/CMMN11.xsd";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Map<String, BaseCmmnXmlConverter> elementConverters = new HashMap<String, BaseCmmnXmlConverter>();
    protected static Map<String, BaseCmmnXmlConverter> textConverters = new HashMap<String, BaseCmmnXmlConverter>();
    protected ClassLoader classloader;

    public static void addElementConverter(BaseCmmnXmlConverter converter) {
        elementConverters.put(converter.getXMLElementName(), converter);
    }

    public static void addTextConverter(BaseCmmnXmlConverter converter) {
        textConverters.put(converter.getXMLElementName(), converter);
    }

    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider) {
        return this.convertToCmmnModel(inputStreamProvider, true, true);
    }

    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml) {
        return this.convertToCmmnModel(inputStreamProvider, validateSchema, enableSafeBpmnXml, DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CmmnModel convertToCmmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml, String encoding) {
        Throwable throwable;
        InputStreamReader in;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        if (validateSchema) {
            try {
                in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
                throwable = null;
                try {
                    if (!enableSafeBpmnXml) {
                        this.validateModel(inputStreamProvider);
                    } else {
                        this.validateModel(xif.createXMLStreamReader(in));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CmmnXMLException("The CMMN 1.1 xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new CmmnXMLException("Error while reading the CMMN 1.1 XML", e);
            }
            catch (Exception e) {
                throw new CmmnXMLException(e.getMessage(), e);
            }
        }
        try {
            in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
            throwable = null;
            try {
                CmmnModel cmmnModel = this.convertToCmmnModel(xif.createXMLStreamReader(in));
                return cmmnModel;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new CmmnXMLException("The CMMN 1.1 xml is not properly encoded", e);
        }
        catch (XMLStreamException e) {
            throw new CmmnXMLException("Error while reading the CMMN 1.1 XML", e);
        }
        catch (IOException e) {
            throw new CmmnXMLException(e.getMessage(), e);
        }
    }

    public CmmnModel convertToCmmnModel(XMLStreamReader xtr) {
        ConversionHelper conversionHelper = new ConversionHelper();
        conversionHelper.setCmmnModel(new CmmnModel());
        try {
            String currentXmlElement = null;
            while (xtr.hasNext()) {
                try {
                    xtr.next();
                }
                catch (Exception e) {
                    LOGGER.debug("Error reading CMMN XML document", (Throwable)e);
                    throw new CmmnXMLException("Error reading XML", e);
                }
                if (xtr.isStartElement()) {
                    currentXmlElement = xtr.getLocalName();
                    if (!elementConverters.containsKey(currentXmlElement)) continue;
                    elementConverters.get(currentXmlElement).convertToCmmnModel(xtr, conversionHelper);
                    continue;
                }
                if (xtr.isEndElement()) {
                    currentXmlElement = null;
                    if (!elementConverters.containsKey(xtr.getLocalName())) continue;
                    elementConverters.get(xtr.getLocalName()).elementEnd(xtr, conversionHelper);
                    continue;
                }
                if (!xtr.isCharacters() && xtr.getEventType() != 12 || currentXmlElement == null || !textConverters.containsKey(currentXmlElement)) continue;
                textConverters.get(currentXmlElement).convertToCmmnModel(xtr, conversionHelper);
            }
        }
        catch (CmmnXMLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error processing CMMN XML document", (Throwable)e);
            throw new CmmnXMLException("Error processing CMMN XML document", e);
        }
        this.processCmmnElements(conversionHelper);
        return conversionHelper.getCmmnModel();
    }

    public void validateModel(InputStreamProvider inputStreamProvider) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStreamProvider.getInputStream()));
    }

    public void validateModel(XMLStreamReader xmlStreamReader) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(xmlStreamReader));
    }

    protected Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        if (this.classloader != null) {
            schema = factory.newSchema(this.classloader.getResource(XSD_LOCATION));
        }
        if (schema == null) {
            schema = factory.newSchema(this.getClass().getClassLoader().getResource(XSD_LOCATION));
        }
        if (schema == null) {
            throw new CmmnXMLException("CMND XSD could not be found");
        }
        return schema;
    }

    public byte[] convertToXML(CmmnModel model) {
        return this.convertToXML(model, DEFAULT_ENCODING);
    }

    public byte[] convertToXML(CmmnModel model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            DefinitionsRootExport.writeRootElement(model, xtw, encoding);
            for (Case caseModel : model.getCases()) {
                if (caseModel.getPlanModel().getPlanItems().isEmpty()) continue;
                CaseExport.writeCase(model, caseModel, xtw);
                Stage planModel = caseModel.getPlanModel();
                StageExport.getInstance().writePlanItemDefinition(model, planModel, xtw);
                xtw.writeEndElement();
            }
            CmmnDIExport.writeCmmnDI(model, xtw);
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            outputStream.close();
            xtw.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error writing CMMN XML", (Throwable)e);
            throw new XMLException("Error writing CMMN XML", e);
        }
    }

    protected void processCmmnElements(ConversionHelper conversionHelper) {
        CmmnModel cmmnModel = conversionHelper.getCmmnModel();
        for (Case caze : cmmnModel.getCases()) {
            this.processPlanFragment(cmmnModel, (PlanFragment)caze.getPlanModel());
        }
        this.ensureIds(conversionHelper.getPlanFragments(), "planFragment_");
        this.ensureIds(conversionHelper.getStages(), "stage_");
        this.ensureIds(conversionHelper.getEntryCriteria(), "entryCriterion_");
        this.ensureIds(conversionHelper.getExitCriteria(), "exitCriterion_");
        this.ensureIds(conversionHelper.getSentries(), "sentry_");
        this.ensureIds(conversionHelper.getSentryOnParts(), "onPart_");
        this.ensureIds(conversionHelper.getSentryIfParts(), "ifPart_");
        this.ensureIds(conversionHelper.getPlanItems(), "planItem_");
        this.ensureIds(conversionHelper.getPlanItemDefinitions(), "planItemDefinition_");
        for (Case caze : cmmnModel.getCases()) {
            this.processSentries(caze.getPlanModel(), (PlanFragment)caze.getPlanModel());
            for (CaseElement caseElement : conversionHelper.getCaseElements().get(caze)) {
                caze.getAllCaseElements().put(caseElement.getId(), caseElement);
            }
        }
        for (SentryOnPart sentryOnPart : conversionHelper.getSentryOnParts()) {
            Optional<PlanItem> planItem = conversionHelper.findPlanItem(sentryOnPart.getSourceRef());
            if (!planItem.isPresent()) continue;
            sentryOnPart.setSource(planItem.get());
        }
        for (PlanItem planItem : conversionHelper.getPlanItems()) {
            planItem.getEntryDependencies().addAll(PlanItemDependencyUtil.getEntryDependencies(planItem));
            planItem.getExitDependencies().addAll(PlanItemDependencyUtil.getExitDependencies(planItem));
            planItem.getEntryDependencies().forEach(entryDependency -> entryDependency.addEntryDependentPlanItem(planItem));
            planItem.getExitDependencies().forEach(exitDependency -> exitDependency.addExitDependentPlanItem(planItem));
        }
        for (CmmnDiShape diShape : conversionHelper.getDiShapes()) {
            cmmnModel.addGraphicInfo(diShape.getCmmnElementRef(), diShape.getGraphicInfo());
        }
        for (CmmnDiEdge diEdge : conversionHelper.getDiEdges()) {
            Association association = new Association();
            association.setId(diEdge.getId());
            association.setSourceRef(diEdge.getCmmnElementRef());
            association.setTargetRef(diEdge.getTargetCmmnElementRef());
            String planItemSourceRef = null;
            PlanItem planItem = cmmnModel.findPlanItem(association.getSourceRef());
            if (planItem == null) {
                planItem = cmmnModel.findPlanItem(association.getTargetRef());
                planItemSourceRef = association.getTargetRef();
            } else {
                planItemSourceRef = association.getSourceRef();
            }
            if (planItem != null) {
                for (Criterion criterion : planItem.getEntryCriteria()) {
                    SentryOnPart sentryOnPart;
                    Sentry sentry = criterion.getSentry();
                    if (sentry.getOnParts().size() <= 0 || !planItemSourceRef.equals((sentryOnPart = (SentryOnPart)sentry.getOnParts().get(0)).getSourceRef())) continue;
                    association.setTransitionEvent(sentryOnPart.getStandardEvent());
                }
            }
            cmmnModel.addAssociation(association);
            cmmnModel.addFlowGraphicInfoList(association.getId(), diEdge.getWaypoints());
        }
    }

    protected void processPlanFragment(CmmnModel cmmnModel, PlanFragment planFragment) {
        this.processPlanItems(cmmnModel, planFragment);
        if (planFragment instanceof Stage) {
            Stage stage = (Stage)planFragment;
            for (PlanItemDefinition planItemDefinition : stage.getPlanItemDefinitions()) {
                if (!(planItemDefinition instanceof PlanFragment)) continue;
                this.processPlanFragment(cmmnModel, (PlanFragment)planItemDefinition);
            }
            if (!stage.getExitCriteria().isEmpty()) {
                this.resolveExitCriteriaSentry((HasExitCriteria)stage);
            }
        }
    }

    protected void processPlanItems(CmmnModel cmmnModel, PlanFragment planFragment) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            Stage parentStage = planItem.getParentStage();
            PlanItemDefinition planItemDefinition = parentStage.findPlanItemDefinitionInStageOrUpwards(planItem.getDefinitionRef());
            if (planItemDefinition == null) {
                throw new FlowableException("No matching plan item definition found for reference " + planItem.getDefinitionRef() + " of plan item " + planItem.getId());
            }
            planItem.setPlanItemDefinition(planItemDefinition);
            if (!planItem.getEntryCriteria().isEmpty()) {
                this.resolveEntryCriteria((HasEntryCriteria)planItem);
            }
            if (!planItem.getExitCriteria().isEmpty()) {
                Task task;
                boolean exitCriteriaAllowed = true;
                if (planItemDefinition instanceof Task && !(task = (Task)planItemDefinition).isBlocking() && StringUtils.isEmpty((CharSequence)task.getBlockingExpression())) {
                    exitCriteriaAllowed = false;
                }
                if (exitCriteriaAllowed) {
                    this.resolveExitCriteriaSentry((HasExitCriteria)planItem);
                } else {
                    LOGGER.warn("Ignoring exit criteria on plan item {}", (Object)planItem.getId());
                    planItem.getExitCriteria().clear();
                }
            }
            if (planItemDefinition instanceof PlanFragment) {
                PlanFragment planItemPlanFragment = (PlanFragment)planItemDefinition;
                planItemPlanFragment.setPlanItem(planItem);
                this.processPlanFragment(cmmnModel, planItemPlanFragment);
                continue;
            }
            if (planItemDefinition instanceof ProcessTask) {
                Process process;
                ProcessTask processTask = (ProcessTask)planItemDefinition;
                if (processTask.getProcessRef() == null || (process = cmmnModel.getProcessById(processTask.getProcessRef())) == null) continue;
                processTask.setProcess(process);
                continue;
            }
            if (planItemDefinition instanceof DecisionTask) {
                Decision decision;
                DecisionTask decisionTask = (DecisionTask)planItemDefinition;
                if (decisionTask.getDecisionRef() == null || (decision = cmmnModel.getDecisionById(decisionTask.getDecisionRef())) == null) continue;
                decisionTask.setDecision(decision);
                continue;
            }
            if (planItemDefinition instanceof TimerEventListener) {
                TimerEventListener timerEventListener = (TimerEventListener)planItemDefinition;
                String sourceRef = timerEventListener.getTimerStartTriggerSourceRef();
                PlanItem startTriggerPlanItem = timerEventListener.getParentStage().findPlanItemInPlanFragmentOrUpwards(sourceRef);
                if (startTriggerPlanItem == null) continue;
                timerEventListener.setTimerStartTriggerPlanItem(startTriggerPlanItem);
                Criterion criterion = new Criterion();
                criterion.setEntryCriterion(true);
                SentryOnPart sentryOnPart = new SentryOnPart();
                sentryOnPart.setSourceRef(startTriggerPlanItem.getId());
                sentryOnPart.setSource(startTriggerPlanItem);
                sentryOnPart.setStandardEvent(timerEventListener.getTimerStartTriggerStandardEvent());
                Sentry sentry = new Sentry();
                sentry.addSentryOnPart(sentryOnPart);
                criterion.setSentry(sentry);
                planItem.addEntryCriterion(criterion);
                continue;
            }
            if (!(planItemDefinition instanceof CasePageTask)) continue;
            if (planItem.getItemControl() == null) {
                PlanItemControl planItemControl = new PlanItemControl();
                planItem.setItemControl(planItemControl);
            }
            if (planItem.getItemControl().getParentCompletionRule() != null) continue;
            ParentCompletionRule parentCompletionRule = new ParentCompletionRule();
            parentCompletionRule.setType("ignore");
            planItem.getItemControl().setParentCompletionRule(parentCompletionRule);
        }
    }

    protected void resolveEntryCriteria(HasEntryCriteria hasEntryCriteria) {
        for (Criterion entryCriterion : hasEntryCriteria.getEntryCriteria()) {
            Sentry sentry = entryCriterion.getParent().findSentry(entryCriterion.getSentryRef());
            if (sentry != null) {
                entryCriterion.setSentry(sentry);
                continue;
            }
            throw new FlowableException("No sentry found for reference " + entryCriterion.getSentryRef() + " of entry criterion " + entryCriterion.getId());
        }
    }

    protected void resolveExitCriteriaSentry(HasExitCriteria hasExitCriteria) {
        for (Criterion exitCriterion : hasExitCriteria.getExitCriteria()) {
            Sentry sentry = exitCriterion.getParent().findSentry(exitCriterion.getSentryRef());
            if (sentry != null) {
                exitCriterion.setSentry(sentry);
                continue;
            }
            throw new FlowableException("No sentry found for reference " + exitCriterion.getSentryRef() + " of exit criterion " + exitCriterion.getId());
        }
    }

    protected void processSentries(Stage planModelStage, PlanFragment planFragment) {
        for (Sentry sentry : planFragment.getSentries()) {
            for (SentryOnPart onPart : sentry.getOnParts()) {
                PlanItem planItem = planModelStage.findPlanItemInPlanFragmentOrDownwards(onPart.getSourceRef());
                if (planItem != null) {
                    onPart.setSource(planItem);
                    continue;
                }
                throw new FlowableException("Could not resolve on part source reference " + onPart.getSourceRef() + " of sentry " + sentry.getId());
            }
        }
        for (PlanItem planItem : planFragment.getPlanItems()) {
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment)) continue;
            this.processSentries(planModelStage, (PlanFragment)planItem.getPlanItemDefinition());
        }
    }

    protected void ensureIds(List<? extends BaseElement> elements, String idPrefix) {
        HashMap<String, BaseElement> elementsWithId = new HashMap<String, BaseElement>();
        HashSet<BaseElement> baseElementsWithoutId = new HashSet<BaseElement>();
        for (BaseElement baseElement : elements) {
            if (baseElement.getId() != null) {
                elementsWithId.put(baseElement.getId(), baseElement);
                continue;
            }
            baseElementsWithoutId.add(baseElement);
        }
        if (!baseElementsWithoutId.isEmpty()) {
            int counter = 1;
            for (BaseElement baseElement : baseElementsWithoutId) {
                String id = idPrefix + counter++;
                while (elementsWithId.containsKey(id)) {
                    id = idPrefix + counter++;
                }
                baseElement.setId(id);
                elementsWithId.put(id, baseElement);
            }
        }
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public static Map<String, BaseCmmnXmlConverter> getConvertersToCmmnModelMap() {
        return elementConverters;
    }

    public static void setConvertersToCmmnModelMap(Map<String, BaseCmmnXmlConverter> convertersToCmmnModelMap) {
        elementConverters = convertersToCmmnModelMap;
    }

    static {
        CmmnXmlConverter.addElementConverter(new DefinitionsXmlConverter());
        CmmnXmlConverter.addElementConverter(new DocumentationXmlConverter());
        CmmnXmlConverter.addElementConverter(new CaseXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanModelXmlConverter());
        CmmnXmlConverter.addElementConverter(new StageXmlConverter());
        CmmnXmlConverter.addElementConverter(new MilestoneXmlConverter());
        CmmnXmlConverter.addElementConverter(new TaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new HumanTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemXmlConverter());
        CmmnXmlConverter.addElementConverter(new ItemControlXmlConverter());
        CmmnXmlConverter.addElementConverter(new DefaultControlXmlConverter());
        CmmnXmlConverter.addElementConverter(new RequiredRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new RepetitionRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new ManualActivationRuleXmlConverter());
        CmmnXmlConverter.addElementConverter(new SentryXmlConverter());
        CmmnXmlConverter.addElementConverter(new EntryCriterionXmlConverter());
        CmmnXmlConverter.addElementConverter(new ExitCriterionXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemOnPartXmlConverter());
        CmmnXmlConverter.addElementConverter(new SentryIfPartXmlConverter());
        CmmnXmlConverter.addElementConverter(new CaseTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new ProcessXmlConverter());
        CmmnXmlConverter.addElementConverter(new ProcessTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new DecisionXmlConverter());
        CmmnXmlConverter.addElementConverter(new DecisionTaskXmlConverter());
        CmmnXmlConverter.addElementConverter(new GenericEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new TimerEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new UserEventListenerXmlConverter());
        CmmnXmlConverter.addElementConverter(new PlanItemStartTriggerXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiShapeXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiEdgeXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiBoundsXmlConverter());
        CmmnXmlConverter.addElementConverter(new CmmnDiWaypointXmlConverter());
        CmmnXmlConverter.addTextConverter(new StandardEventXmlConverter());
        CmmnXmlConverter.addTextConverter(new ProcessRefExpressionXmlConverter());
        CmmnXmlConverter.addTextConverter(new CaseRefExpressionXmlConverter());
        CmmnXmlConverter.addTextConverter(new DecisionRefExpressionXmlConverter());
        CmmnXmlConverter.addTextConverter(new ConditionXmlConverter());
        CmmnXmlConverter.addTextConverter(new TimerExpressionXmlConverter());
        CmmnXmlConverter.addElementConverter(new ExtensionElementsXMLConverter());
    }
}

