/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.Process;

public class FlowableEventListenerParser
extends BaseChildElementParser {
    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        EventListener listener = new EventListener();
        BpmnXMLUtil.addXMLLocation((BaseElement)listener, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "class"))) {
            listener.setImplementation(xtr.getAttributeValue(null, "class"));
            listener.setImplementationType("class");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "delegateExpression"))) {
            listener.setImplementation(xtr.getAttributeValue(null, "delegateExpression"));
            listener.setImplementationType("delegateExpression");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "throwEvent"))) {
            String eventType = xtr.getAttributeValue(null, "throwEvent");
            if ("signal".equals(eventType)) {
                listener.setImplementationType("throwSignalEvent");
                listener.setImplementation(xtr.getAttributeValue(null, "signalName"));
            } else if ("globalSignal".equals(eventType)) {
                listener.setImplementationType("throwGlobalSignalEvent");
                listener.setImplementation(xtr.getAttributeValue(null, "signalName"));
            } else if ("message".equals(eventType)) {
                listener.setImplementationType("throwMessageEvent");
                listener.setImplementation(xtr.getAttributeValue(null, "messageName"));
            } else if ("error".equals(eventType)) {
                listener.setImplementationType("throwErrorEvent");
                listener.setImplementation(xtr.getAttributeValue(null, "errorCode"));
            } else {
                listener.setImplementationType("invalidThrowEvent");
            }
        }
        listener.setEvents(xtr.getAttributeValue(null, "events"));
        listener.setEntityType(xtr.getAttributeValue(null, "entityType"));
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "onTransaction"))) {
            listener.setOnTransaction(xtr.getAttributeValue(null, "onTransaction"));
        }
        Process parentProcess = (Process)parentElement;
        parentProcess.getEventListeners().add(listener);
    }

    @Override
    public String getElementName() {
        return "eventListener";
    }
}

