/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.IOParameter;

public class OutParameterParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "out";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        String source = xtr.getAttributeValue(null, "source");
        String sourceExpression = xtr.getAttributeValue(null, "sourceExpression");
        String target = xtr.getAttributeValue(null, "target");
        if ((StringUtils.isNotEmpty((CharSequence)source) || StringUtils.isNotEmpty((CharSequence)sourceExpression)) && StringUtils.isNotEmpty((CharSequence)target)) {
            IOParameter parameter = new IOParameter();
            if (StringUtils.isNotEmpty((CharSequence)sourceExpression)) {
                parameter.setSourceExpression(sourceExpression);
            } else {
                parameter.setSource(source);
            }
            parameter.setTarget(target);
            String transientValue = xtr.getAttributeValue(null, "transient");
            if ("true".equalsIgnoreCase(transientValue)) {
                parameter.setTransient(true);
            }
            if (parentElement instanceof CallActivity) {
                ((CallActivity)parentElement).getOutParameters().add(parameter);
            } else if (parentElement instanceof CaseServiceTask) {
                ((CaseServiceTask)parentElement).getOutParameters().add(parameter);
            }
        }
    }
}

