/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.hamcrest.Description;

public class IsDayOfWeek<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, DayOfWeek> converter;
    private final TemporalProvider<List<DayOfWeek>> expected;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsDayOfWeek(TemporalConverter<T, DayOfWeek> converter, TemporalProvider<List<DayOfWeek>> expected, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsDayOfWeek(TemporalConverter<T, DayOfWeek> converter, TemporalProvider<List<DayOfWeek>> expected) {
        this(converter, expected, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        DayOfWeek actualValue;
        List<DayOfWeek> expectedValues = this.expected.apply(this.zone);
        if (!expectedValues.contains(actualValue = this.converter.apply(actual, this.zone))) {
            mismatchDescription.appendText("the date is on a " + this.describe(actualValue));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        List<DayOfWeek> expectedValues = this.expected.apply(this.zone);
        if (expectedValues.size() > 1) {
            List<DayOfWeek> headValues = expectedValues.subList(0, expectedValues.size() - 1);
            DayOfWeek tailValue = expectedValues.get(expectedValues.size() - 1);
            description.appendText("the date is on a " + headValues.stream().map(this::describe).collect(Collectors.joining(", ")) + " or " + this.describe(tailValue));
        } else {
            description.appendText("the date is on a " + this.describe(expectedValues.get(0)));
        }
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsDayOfWeek<T>(this.converter, this.expected, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsDayOfWeek<T>(this.converter, this.expected, this.zone, locale);
    }

    private String describe(DayOfWeek actualValue) {
        return actualValue.getDisplayName(TextStyle.FULL, this.locale);
    }
}

