/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.util.Optional;
import org.elasticsearch.nativeaccess.AbstractNativeAccess;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;
import org.elasticsearch.nativeaccess.lib.VectorLibrary;

abstract class PosixNativeAccess
extends AbstractNativeAccess {
    protected final PosixCLibrary libc;
    protected final VectorSimilarityFunctions vectorDistance;
    static final String ENABLE_JDK_VECTOR_LIBRARY = "org.elasticsearch.nativeaccess.enableVectorLibrary";

    PosixNativeAccess(String name, NativeLibraryProvider libraryProvider) {
        super(name, libraryProvider);
        this.libc = libraryProvider.getLibrary(PosixCLibrary.class);
        this.vectorDistance = PosixNativeAccess.vectorSimilarityFunctionsOrNull(libraryProvider);
    }

    static VectorSimilarityFunctions vectorSimilarityFunctionsOrNull(NativeLibraryProvider libraryProvider) {
        if (PosixNativeAccess.isNativeVectorLibSupported()) {
            VectorSimilarityFunctions lib = new VectorSimilarityFunctions(libraryProvider.getLibrary(VectorLibrary.class));
            logger.info("Using native vector library; to disable start with -Dorg.elasticsearch.nativeaccess.enableVectorLibrary=false");
            return lib;
        }
        return null;
    }

    @Override
    public boolean definitelyRunningAsRoot() {
        return this.libc.geteuid() == 0;
    }

    @Override
    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions() {
        return Optional.ofNullable(this.vectorDistance);
    }

    static boolean isNativeVectorLibSupported() {
        return Runtime.version().feature() >= 21 && PosixNativeAccess.isMacOrLinuxAarch64() && PosixNativeAccess.checkEnableSystemProperty();
    }

    static boolean isMacOrLinuxAarch64() {
        String name = System.getProperty("os.name");
        return (name.startsWith("Mac") || name.startsWith("Linux")) && System.getProperty("os.arch").equals("aarch64");
    }

    static boolean checkEnableSystemProperty() {
        return Optional.ofNullable(System.getProperty(ENABLE_JDK_VECTOR_LIBRARY)).map(Boolean::valueOf).orElse(Boolean.TRUE);
    }
}

