/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;

public class DebugHelper {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final boolean DEBUG_PROFILE_REGISTRY;
    public static final boolean DEBUG_ENGINE;
    public static final boolean DEBUG_ENGINE_SESSION;
    public static final boolean DEBUG_CERTIFICATE_CHECKER_UNSIGNED;
    public static final boolean DEBUG_CERTIFICATE_CHECKER_UNTRUSTED;

    static {
        DebugOptions options = (DebugOptions)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), DebugOptions.class);
        if (options != null) {
            DEBUG_PROFILE_REGISTRY = options.getBooleanOption("org.eclipse.equinox.p2.engine/profileregistry/debug", false);
            DEBUG_ENGINE = options.getBooleanOption("org.eclipse.equinox.p2.engine/engine/debug", false);
            DEBUG_ENGINE_SESSION = options.getBooleanOption("org.eclipse.equinox.p2.engine/enginesession/debug", false);
            DEBUG_CERTIFICATE_CHECKER_UNSIGNED = options.getBooleanOption("org.eclipse.equinox.p2.engine/certificatechecker/unsigned", false);
            DEBUG_CERTIFICATE_CHECKER_UNTRUSTED = options.getBooleanOption("org.eclipse.equinox.p2.engine/certificatechecker/untrusted", false);
        } else {
            DEBUG_PROFILE_REGISTRY = false;
            DEBUG_ENGINE = false;
            DEBUG_ENGINE_SESSION = false;
            DEBUG_CERTIFICATE_CHECKER_UNSIGNED = false;
            DEBUG_CERTIFICATE_CHECKER_UNTRUSTED = false;
        }
    }

    public static void debug(String name, String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append("org.eclipse.equinox.p2.engine-" + name);
        buffer.append("] ");
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] " + LINE_SEPARATOR);
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public static String formatArray(Collection<? extends Object> array, boolean toString, boolean newLines) {
        if (array == null || array.size() == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        boolean first = true;
        for (Object object : array) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            if (toString) {
                buffer.append(object.toString());
            } else {
                buffer.append(object.getClass().getName());
            }
            if (newLines) {
                buffer.append(LINE_SEPARATOR);
                continue;
            }
            buffer.append(' ');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String formatOperation(PhaseSet phaseSet, Operand[] operands, ProvisioningContext context) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("phaseSet=" + DebugHelper.formatPhaseSet(phaseSet));
        buffer.append(",");
        buffer.append(LINE_SEPARATOR);
        buffer.append("operands=" + DebugHelper.formatOperands(operands));
        buffer.append(",");
        buffer.append(LINE_SEPARATOR);
        buffer.append("context=" + DebugHelper.formatContext(context));
        return buffer.toString();
    }

    public static String formatOperands(Operand[] operands) {
        String[] operandStrings = new String[operands.length];
        int i = 0;
        while (i < operands.length) {
            if (operands[i] instanceof InstallableUnitOperand) {
                InstallableUnitOperand iuOperand = (InstallableUnitOperand)operands[i];
                operandStrings[i] = DebugHelper.formatInstallableUnitOperand(iuOperand);
            } else {
                operandStrings[i] = operands[i].toString();
            }
            ++i;
        }
        return DebugHelper.formatArray(Arrays.asList(operandStrings), true, true);
    }

    public static String formatInstallableUnitOperand(InstallableUnitOperand iuOperand) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(iuOperand.first());
        if (iuOperand.first() != null && iuOperand.first().getFragments() != null) {
            buffer.append(DebugHelper.formatArray(iuOperand.first().getFragments(), true, false));
        }
        buffer.append(" --> ");
        buffer.append(iuOperand.second());
        if (iuOperand.second() != null && iuOperand.second().getFragments() != null) {
            buffer.append(DebugHelper.formatArray(iuOperand.second().getFragments(), true, false));
        }
        return buffer.toString();
    }

    public static String formatPhaseSet(PhaseSet phaseSet) {
        StringBuilder buffer = new StringBuilder(phaseSet.getClass().getName());
        buffer.append(DebugHelper.formatArray(Arrays.asList(phaseSet.getPhases()), false, false));
        return buffer.toString();
    }

    public static String formatContext(ProvisioningContext context) {
        return context.toString();
    }

    public static String formatAction(ProvisioningAction action, Map<String, Object> parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(action.getClass().getName());
        if (action instanceof ParameterizedProvisioningAction) {
            ParameterizedProvisioningAction parameterizedAction = (ParameterizedProvisioningAction)action;
            buffer.append("{action=" + parameterizedAction.getAction().getClass().getName());
            buffer.append(", actionText=" + parameterizedAction.getActionText() + "}");
        }
        buffer.append(LINE_SEPARATOR);
        buffer.append("parameters=" + DebugHelper.formatParameters(parameters));
        return buffer.toString();
    }

    public static String formatParameters(Map<String, ? extends Object> parameters) {
        Iterator<Map.Entry<String, ? extends Object>> it = parameters.entrySet().iterator();
        if (!it.hasNext()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        while (true) {
            Map.Entry<String, ? extends Object> e = it.next();
            String key = e.getKey();
            buffer.append(key);
            buffer.append('=');
            Object value = e.getValue();
            if (value == null) {
                buffer.append(value);
            } else if (value instanceof String || value instanceof File || value instanceof Operand || value instanceof IArtifactKey || value instanceof IInstallableUnit) {
                buffer.append(value);
            } else if (value instanceof IProfile) {
                buffer.append(((IProfile)value).getProfileId());
            } else {
                buffer.append(value.getClass().getName());
            }
            if (!it.hasNext()) break;
            buffer.append(',');
            buffer.append(LINE_SEPARATOR);
            buffer.append(' ');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

