/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;

public class UnionIteration<E, X extends Exception>
extends LookAheadIteration<E, X> {
    private final Iterator<? extends Iteration<? extends E, X>> argIter;
    private volatile Iteration<? extends E, X> currentIter;

    public UnionIteration(Iteration<? extends E, X> ... args) {
        this(Arrays.asList(args));
    }

    public UnionIteration(Iterable<? extends Iteration<? extends E, X>> args) {
        this.argIter = args.iterator();
        this.currentIter = new EmptyIteration<E, X>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected E getNextElement() throws X {
        if (this.isClosed()) {
            return null;
        }
        Iteration<E, X> nextCurrentIter;
        while ((nextCurrentIter = this.currentIter) == null || !nextCurrentIter.hasNext()) {
            Iterations.closeCloseable(nextCurrentIter);
            UnionIteration unionIteration = this;
            synchronized (unionIteration) {
                if (!this.argIter.hasNext()) {
                    return null;
                }
                this.currentIter = this.argIter.next();
            }
        }
        return nextCurrentIter.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            try {
                ArrayList<Throwable> collectedExceptions = new ArrayList<Throwable>();
                UnionIteration unionIteration = this;
                synchronized (unionIteration) {
                    while (this.argIter.hasNext()) {
                        try {
                            Iterations.closeCloseable(this.argIter.next());
                        }
                        catch (Throwable e) {
                            collectedExceptions.add(e);
                        }
                    }
                }
                if (!collectedExceptions.isEmpty()) {
                    throw new UndeclaredThrowableException((Throwable)collectedExceptions.get(0));
                }
            }
            finally {
                Iterations.closeCloseable(this.currentIter);
            }
        }
    }
}

