/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JDKPlatform;

public class JDK15Platform
implements JDKPlatform {
    protected static final ConcurrentHashMap patternCache = new ConcurrentHashMap();
    protected static final ConcurrentHashMap regexpPatternCache = new ConcurrentHashMap();

    @Override
    public Boolean conformLike(Object left, Object right) {
        boolean match;
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = (Pattern)patternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            String convertedRight = Helper.convertLikeToRegex((String)right);
            pattern = Pattern.compile(convertedRight);
            if (patternCache.size() > 100) {
                patternCache.remove(((ConcurrentHashMap.KeySetView)patternCache.keySet()).iterator().next());
            }
            patternCache.put(right, pattern);
        }
        if (match = pattern.matcher((String)left).matches()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean conformRegexp(Object left, Object right) {
        boolean match;
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = (Pattern)regexpPatternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            pattern = Pattern.compile((String)right);
            if (regexpPatternCache.size() > 100) {
                regexpPatternCache.remove(((ConcurrentHashMap.KeySetView)regexpPatternCache.keySet()).iterator().next());
            }
            regexpPatternCache.put(right, pattern);
        }
        if (match = pattern.matcher((String)left).matches()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isSQLXML(Object object) {
        return false;
    }

    @Override
    public String getStringAndFreeSQLXML(Object sqlXml) throws SQLException {
        return null;
    }
}

